/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.ChannelReadObserver;
import com.limegroup.gnutella.io.InterestReadChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractChannelInterestRead
implements ChannelReadObserver,
InterestReadChannel {
    protected ByteBuffer buffer = ByteBuffer.allocate(this.getBufferSize());
    protected InterestReadChannel source;
    protected boolean shutdown;

    protected abstract int getBufferSize();

    public int read(ByteBuffer dst) {
        return BufferUtils.transfer(this.buffer, dst);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public InterestReadChannel getReadChannel() {
        return this.source;
    }

    public void setReadChannel(InterestReadChannel newChannel) {
        this.source = newChannel;
    }

    public void interest(boolean status) {
        this.source.interest(status);
    }

    public void close() throws IOException {
        this.source.close();
    }

    public boolean isOpen() {
        return this.source.isOpen();
    }

    public void handleIOException(IOException iox) {
    }
}

