/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.InterruptedIOException;
import com.limegroup.gnutella.io.Shutdownable;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class BufferOutputStream
extends OutputStream
implements Shutdownable {
    private static final Log LOG = LogFactory.getLog(BufferOutputStream.class);
    private final Object LOCK = new Object();
    private final Shutdownable handler;
    private final WriteObserver writeObserver;
    private final ByteBuffer buffer;
    private final InterestWriteChannel channel;
    private boolean shutdown = false;

    BufferOutputStream(ByteBuffer buffer, Shutdownable handler, WriteObserver observer, InterestWriteChannel channel) {
        this.handler = handler;
        this.buffer = buffer;
        this.channel = channel;
        this.writeObserver = observer;
    }

    Object getBufferLock() {
        return this.LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int x) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.waitImpl();
            this.buffer.put((byte)(x & 0xFF));
            this.channel.interest(this.writeObserver, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int off, int len) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            while (len > 0) {
                this.waitImpl();
                int available = Math.min(this.buffer.remaining(), len);
                this.buffer.put(buf, off, available);
                off += available;
                len -= available;
                this.channel.interest(this.writeObserver, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            while (this.buffer.position() > 0) {
                if (this.shutdown) {
                    throw new IOException("socket closed");
                }
                try {
                    this.LOCK.wait();
                }
                catch (InterruptedException ix) {
                    throw new InterruptedIOException(ix);
                }
            }
        }
    }

    private void waitImpl() throws IOException {
        while (!this.buffer.hasRemaining()) {
            if (this.shutdown) {
                throw new IOException("socket closed");
            }
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException ix) {
                throw new InterruptedIOException(ix);
            }
        }
        if (this.shutdown) {
            throw new IOException("socket closed");
        }
    }

    public void close() {
        this.handler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            this.shutdown = true;
            this.LOCK.notify();
        }
    }
}

