/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.NIODispatcher;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;

class SocketInterestReadAdapter
implements InterestReadChannel {
    private static final IOException OOM = new IOException();
    private SocketChannel channel;

    SocketInterestReadAdapter(SocketChannel channel) {
        this.channel = channel;
    }

    public void interest(boolean status) {
        NIODispatcher.instance().interestRead(this.channel, status);
    }

    public int read(ByteBuffer dst) throws IOException {
        try {
            return this.channel.read(dst);
        }
        catch (OutOfMemoryError oom) {
            System.gc();
            throw OOM;
        }
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        this.channel.close();
    }

    ReadableByteChannel getChannel() {
        return this.channel;
    }
}

