/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.Timeoutable;
import com.limegroup.gnutella.util.BinaryHeap;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeoutController {
    private static final Log LOG = LogFactory.getLog(TimeoutController.class);
    private final BinaryHeap items = new BinaryHeap(20, true);
    private final List timedout = new ArrayList(100);

    synchronized int getNumPendingTimeouts() {
        return this.items.size();
    }

    public synchronized void addTimeout(Timeoutable t, long now, long timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding timeoutable: " + t + ", now: " + now + ", timeout: " + timeout);
        }
        this.items.insert(new Timeout(t, now, timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTimeouts(long now) {
        Timeout t;
        TimeoutController timeoutController = this;
        synchronized (timeoutController) {
            while (!this.items.isEmpty()) {
                t = (Timeout)this.items.getMax();
                if (t != null && now >= t.expireTime) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Timing out: " + t + ", expired: " + t.expireTime + ", now: " + now + ", length: " + t.timeoutLength);
                    }
                } else {
                    if (t == null || !LOG.isDebugEnabled()) break;
                    LOG.debug("Breaking -- next timeout at: " + t.expireTime + ", now: " + now);
                    break;
                }
                this.timedout.add(t);
                this.items.extractMax();
            }
        }
        for (int i = 0; i < this.timedout.size(); ++i) {
            t = (Timeout)this.timedout.get(i);
            t.timeoutable.notifyTimeout(now, t.expireTime, t.timeoutLength);
        }
        this.timedout.clear();
    }

    public synchronized long getNextExpireTime() {
        if (this.items.isEmpty()) {
            return -1L;
        }
        return ((Timeout)this.items.getMax()).expireTime;
    }

    private static class Timeout
    implements Comparable {
        private long expireTime;
        private Timeoutable timeoutable;
        private long timeoutLength;

        Timeout(Timeoutable timeoutable, long now, long timeout) {
            this.expireTime = now + timeout;
            this.timeoutLength = timeout;
            this.timeoutable = timeoutable;
        }

        public int compareTo(Object o) {
            Timeout b = (Timeout)o;
            return this.expireTime < b.expireTime ? 1 : (this.expireTime > b.expireTime ? -1 : 0);
        }

        public String toString() {
            return "TimeoutWrapper for: " + this.timeoutable;
        }
    }
}

