/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Container {
    private static final Log LOG = LogFactory.getLog(Container.class);
    private final Map STORED = new HashMap();
    private final String filename;

    Container(String name) {
        this.filename = name;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() {
        Map read = this.readFromDisk();
        Container container = this;
        synchronized (container) {
            if (this.STORED.isEmpty()) {
                this.STORED.putAll(read);
            } else {
                Iterator i = read.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry next = i.next();
                    Object k = next.getKey();
                    Object v = next.getValue();
                    Object storedV = this.STORED.get(k);
                    if (storedV == null) {
                        this.STORED.put(k, v);
                        continue;
                    }
                    Object v2 = storedV;
                    synchronized (v2) {
                        if (v instanceof Collection && storedV instanceof Collection) {
                            Collection cv = (Collection)storedV;
                            cv.clear();
                            cv.addAll((Collection)v);
                        } else if (v instanceof Map && storedV instanceof Map) {
                            Map mv = (Map)storedV;
                            mv.clear();
                            mv.putAll((Map)v);
                        } else if (LOG.isWarnEnabled()) {
                            LOG.warn("Unable to reload data, key: " + k);
                        }
                    }
                }
            }
        }
    }

    synchronized Set getSet(String name) {
        Object data = this.STORED.get(name);
        if (data != null) {
            return (Set)data;
        }
        Set set = Collections.synchronizedSet(new HashSet());
        this.STORED.put(name, set);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void clear() {
        Iterator i = this.STORED.entrySet().iterator();
        while (i.hasNext()) {
            Object v;
            Map.Entry next = i.next();
            Object v2 = v = next.getValue();
            synchronized (v2) {
                if (v instanceof Collection) {
                    ((Collection)v).clear();
                } else if (v instanceof Map) {
                    ((Map)v).clear();
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to clear data, key: " + next.getKey());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        HashMap toSave;
        Container container = this;
        synchronized (container) {
            toSave = new HashMap(this.STORED.size());
            Iterator i = this.STORED.entrySet().iterator();
            while (i.hasNext()) {
                Object v;
                Map.Entry next = i.next();
                Object k = next.getKey();
                Object v2 = v = next.getValue();
                synchronized (v2) {
                    if (v instanceof SortedSet) {
                        toSave.put(k, new TreeSet((SortedSet)v));
                    } else if (v instanceof Set) {
                        toSave.put(k, new HashSet((Set)v));
                    } else if (v instanceof Map) {
                        toSave.put(k, new HashMap((Map)v));
                    } else if (v instanceof List) {
                        if (v instanceof RandomAccess) {
                            toSave.put(k, new ArrayList((List)v));
                        } else {
                            toSave.put(k, new LinkedList((List)v));
                        }
                    } else {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Update to clone! key: " + k);
                        }
                        toSave.put(k, v);
                    }
                }
            }
        }
        this.writeToDisk(toSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDisk(Object o) {
        File f = new File(CommonUtils.getUserSettingsDir(), this.filename);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            oos.writeObject(o);
            oos.flush();
            IOUtils.close(oos);
        }
        catch (IOException iox) {
            LOG.warn("Can't write to disk!", iox);
        }
        finally {
            IOUtils.close(oos);
        }
    }

    /*
     * Exception decompiling
     */
    private Map readFromDisk() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

