/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.AbstractLicense;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class WeedLicense
extends AbstractLicense {
    private static final Log LOG = LogFactory.getLog(WeedLicense.class);
    private static final long serialVersionUID = 1230497157539025753L;
    private static String URI = "http://www.weedshare.com/license/verify_usage_rights.aspx";
    private static final String VID = "versionid";
    private static final String CID = "contentid";
    private String artist;
    private String title;
    private String price;
    private boolean valid;

    public static final URI buildURI(String cid, String vid) {
        try {
            return new URI((URI + "?" + VID + "=" + vid + "&" + CID + "=" + cid).toCharArray());
        }
        catch (URIException bad) {
            return null;
        }
    }

    WeedLicense(URI uri) {
        super(uri);
    }

    public String getLicense() {
        return null;
    }

    public URL getLicenseDeed(URN urn) {
        try {
            return new URL("http://weedshare.com/company/policies/summary_usage_rights.aspx");
        }
        catch (MalformedURLException murl) {
            return null;
        }
    }

    public boolean isValid(URN urn) {
        return this.valid;
    }

    public License copy(String license, URI licenseURI) {
        WeedLicense newL = null;
        try {
            newL = (WeedLicense)this.clone();
            newL.licenseLocation = licenseURI;
        }
        catch (CloneNotSupportedException error) {
            ErrorService.error(error);
        }
        return newL;
    }

    public String getLicenseDescription(URN urn) {
        if (this.artist == null && this.title == null && this.price == null) {
            return "Details unknown.";
        }
        StringBuffer sb = new StringBuffer();
        if (this.artist != null) {
            sb.append("Artist: " + this.artist + "\n");
        }
        if (this.title != null) {
            sb.append("Title: " + this.title + "\n");
        }
        if (this.price != null) {
            sb.append("Price: " + this.price);
        }
        return sb.toString();
    }

    protected void clear() {
        this.valid = false;
        this.artist = null;
        this.title = null;
        this.price = null;
    }

    protected String getBody(String url) {
        return super.getBody(url + "&data=1");
    }

    protected void parseDocumentNode(Node doc, boolean liveData) {
        if (!doc.getNodeName().equals("WeedVerifyData")) {
            return;
        }
        NodeList children = doc.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            String value = LimeXMLUtils.getTextContent(child);
            if (name == null || value == null || (value = value.trim()).equals("")) continue;
            if (name.equals("Status")) {
                this.valid = value.equals("Verified");
                continue;
            }
            if (name.equals("Artist")) {
                this.artist = value;
                continue;
            }
            if (name.equals("Title")) {
                this.title = value;
                continue;
            }
            if (!name.equals("Price")) continue;
            this.price = value;
        }
    }
}

