/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPPortCombo
implements IpPort {
    private int _port;
    private InetAddress _addr;
    public static final String DELIM = ":";

    public static IPPortCombo getCombo(byte[] fromNetwork) throws BadPacketException {
        return new IPPortCombo(fromNetwork);
    }

    private IPPortCombo(byte[] networkData) throws BadPacketException {
        if (networkData.length != 6) {
            throw new BadPacketException("Weird Input");
        }
        int port = ByteOrder.ushort2int(ByteOrder.leb2short(networkData, 4));
        if (!NetworkUtils.isValidPort(port)) {
            throw new BadPacketException("Bad Port: " + port);
        }
        this._port = port;
        try {
            byte[] a = new byte[]{networkData[0], networkData[1], networkData[2], networkData[3]};
            this._addr = InetAddress.getByAddress(a);
        }
        catch (UnknownHostException uhe) {
            throw new BadPacketException("bad host.");
        }
        if (!NetworkUtils.isValidAddress(this._addr)) {
            throw new BadPacketException("invalid addr: " + this._addr);
        }
    }

    public IPPortCombo(String hostAddress, int port) throws UnknownHostException, IllegalArgumentException {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("Bad Port: " + port);
        }
        this._port = port;
        this._addr = InetAddress.getByName(hostAddress);
        if (!NetworkUtils.isValidAddress(this._addr)) {
            throw new IllegalArgumentException("invalid addr: " + this._addr);
        }
    }

    public int getPort() {
        return this._port;
    }

    public InetAddress getInetAddress() {
        return this._addr;
    }

    public String getAddress() {
        return this._addr.getHostAddress();
    }

    public byte[] toBytes() {
        byte[] retVal = new byte[6];
        for (int i = 0; i < 4; ++i) {
            retVal[i] = this._addr.getAddress()[i];
        }
        ByteOrder.short2leb((short)this._port, retVal, 4);
        return retVal;
    }

    public boolean equals(Object other) {
        if (other instanceof IPPortCombo) {
            IPPortCombo combo = (IPPortCombo)other;
            return this._addr.equals(combo._addr) && this._port == combo._port;
        }
        return false;
    }

    public int hashCode() {
        return this._addr.hashCode() * this._port;
    }

    public String toString() {
        return this.getAddress() + DELIM + this.getPort();
    }
}

