/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.ContentRequest;
import com.limegroup.gnutella.messages.vendor.ContentResponse;
import com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.SimppRequestVM;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UpdateRequest;
import com.limegroup.gnutella.messages.vendor.UpdateResponse;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.util.IntHashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VendorMessageFactory {
    private static final Log LOG = LogFactory.getLog(VendorMessageFactory.class);
    private static final Comparator COMPARATOR = new ByteArrayComparator();
    private static volatile Map VENDORS = new TreeMap(COMPARATOR);
    private static final BadPacketException UNRECOGNIZED_EXCEPTION = new BadPacketException("Unrecognized Vendor Message");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setParser(int selector, byte[] vendorId, VendorMessageParser parser) {
        if (selector < 0 || selector > 65535) {
            throw new IllegalArgumentException("Selector is out of range: " + selector);
        }
        if (vendorId == null) {
            throw new NullPointerException("Vendor ID is null");
        }
        if (vendorId.length != 4) {
            throw new IllegalArgumentException("Vendor ID must be 4 bytes long");
        }
        if (parser == null) {
            throw new NullPointerException("VendorMessageParser is null");
        }
        Object o = null;
        Map map = VENDORS;
        synchronized (map) {
            Map vendors = VendorMessageFactory.copyVendors();
            IntHashMap selectors = (IntHashMap)vendors.get(vendorId);
            if (selectors == null) {
                selectors = new IntHashMap();
                vendors.put(vendorId, selectors);
            }
            o = selectors.put(selector, parser);
            VENDORS = vendors;
        }
        if (o != null && LOG.isErrorEnabled()) {
            LOG.error("There was already a VendorMessageParser of type " + o.getClass() + " registered for selector " + selector);
        }
    }

    private static Map copyVendors() {
        TreeMap<byte[], IntHashMap> copy = new TreeMap<byte[], IntHashMap>(COMPARATOR);
        Iterator it = VENDORS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            byte[] vendor = (byte[])entry.getKey();
            IntHashMap selectors = (IntHashMap)entry.getValue();
            copy.put(vendor, new IntHashMap(selectors));
        }
        return copy;
    }

    public static VendorMessageParser getParser(int selector, byte[] vendorId) {
        IntHashMap selectors = (IntHashMap)VENDORS.get(vendorId);
        if (selectors == null) {
            return null;
        }
        return (VendorMessageParser)selectors.get(selector);
    }

    public static VendorMessage deriveVendorMessage(byte[] guid, byte ttl, byte hops, byte[] fromNetwork, int network) throws BadPacketException {
        if (fromNetwork.length < 8) {
            ReceivedErrorStat.VENDOR_INVALID_PAYLOAD.incrementStat();
            throw new BadPacketException("Not enough bytes for a VM!!");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(fromNetwork);
        byte[] vendorID = null;
        byte[] restOf = null;
        int selector = -1;
        int version = -1;
        try {
            vendorID = new byte[4];
            bais.read(vendorID, 0, vendorID.length);
            selector = ByteOrder.ushort2int(ByteOrder.leb2short(bais));
            version = ByteOrder.ushort2int(ByteOrder.leb2short(bais));
            restOf = new byte[bais.available()];
            bais.read(restOf, 0, restOf.length);
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
        }
        VendorMessageParser parser = VendorMessageFactory.getParser(selector, vendorID);
        if (parser == null) {
            ReceivedErrorStat.VENDOR_UNRECOGNIZED.incrementStat();
            throw UNRECOGNIZED_EXCEPTION;
        }
        return parser.parse(guid, ttl, hops, version, restOf, network);
    }

    static {
        VendorMessageFactory.setParser(4, VendorMessage.F_BEAR_VENDOR_ID, new HopsFlowVendorMessageParser());
        VendorMessageFactory.setParser(11, VendorMessage.F_LIME_VENDOR_ID, new LimeACKVendorMessageParser());
        VendorMessageFactory.setParser(12, VendorMessage.F_LIME_VENDOR_ID, new ReplyNumberVendorMessageParser());
        VendorMessageFactory.setParser(7, VendorMessage.F_BEAR_VENDOR_ID, new TCPConnectBackVendorMessageParser());
        VendorMessageFactory.setParser(0, VendorMessage.F_NULL_VENDOR_ID, new MessagesSupportedVendorMessageParser());
        VendorMessageFactory.setParser(7, VendorMessage.F_GTKG_VENDOR_ID, new UDPConnectBackVendorMessageParser());
        VendorMessageFactory.setParser(21, VendorMessage.F_LIME_VENDOR_ID, new PushProxyRequestParser());
        VendorMessageFactory.setParser(22, VendorMessage.F_LIME_VENDOR_ID, new PushProxyAcknowledgementParser());
        VendorMessageFactory.setParser(11, VendorMessage.F_BEAR_VENDOR_ID, new QueryStatusRequestParser());
        VendorMessageFactory.setParser(12, VendorMessage.F_BEAR_VENDOR_ID, new QueryStatusResponseParser());
        VendorMessageFactory.setParser(7, VendorMessage.F_LIME_VENDOR_ID, new TCPConnectBackRedirectParser());
        VendorMessageFactory.setParser(8, VendorMessage.F_LIME_VENDOR_ID, new UDPConnectBackRedirectParser());
        VendorMessageFactory.setParser(10, VendorMessage.F_NULL_VENDOR_ID, new CapabilitiesVMParser());
        VendorMessageFactory.setParser(14, VendorMessage.F_LIME_VENDOR_ID, new GiveStatsVendorMessageParser());
        VendorMessageFactory.setParser(15, VendorMessage.F_LIME_VENDOR_ID, new StatisticVendorMessageParser());
        VendorMessageFactory.setParser(16, VendorMessage.F_LIME_VENDOR_ID, new SimppRequestVMParser());
        VendorMessageFactory.setParser(17, VendorMessage.F_LIME_VENDOR_ID, new SimppVMParser());
        VendorMessageFactory.setParser(5, VendorMessage.F_LIME_VENDOR_ID, new UDPCrawlerPingParser());
        VendorMessageFactory.setParser(23, VendorMessage.F_LIME_VENDOR_ID, new HeadPingParser());
        VendorMessageFactory.setParser(24, VendorMessage.F_LIME_VENDOR_ID, new HeadPongParser());
        VendorMessageFactory.setParser(26, VendorMessage.F_LIME_VENDOR_ID, new UpdateRequestParser());
        VendorMessageFactory.setParser(27, VendorMessage.F_LIME_VENDOR_ID, new UpdateResponseParser());
        VendorMessageFactory.setParser(28, VendorMessage.F_LIME_VENDOR_ID, new ContentRequestParser());
        VendorMessageFactory.setParser(29, VendorMessage.F_LIME_VENDOR_ID, new ContentResponseParser());
        VendorMessageFactory.setParser(25, VendorMessage.F_LIME_VENDOR_ID, new HeaderUpdateVendorMessageParser());
    }

    private static class ByteArrayComparator
    implements Comparator {
        private ByteArrayComparator() {
        }

        public int compare(Object o1, Object o2) {
            byte[] a = (byte[])o1;
            byte[] b = (byte[])o2;
            int d = 0;
            for (int i = 0; i < a.length; ++i) {
                d = (a[i] & 0xFF) - (b[i] & 0xFF);
                if (d < 0) {
                    return -1;
                }
                if (d <= 0) continue;
                return 1;
            }
            return 0;
        }
    }

    private static class HeaderUpdateVendorMessageParser
    implements VendorMessageParser {
        private HeaderUpdateVendorMessageParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new HeaderUpdateVendorMessage(guid, ttl, hops, version, restOf);
        }
    }

    private static class ContentResponseParser
    implements VendorMessageParser {
        private ContentResponseParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new ContentResponse(guid, ttl, hops, version, restOf);
        }
    }

    private static class ContentRequestParser
    implements VendorMessageParser {
        private ContentRequestParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new ContentRequest(guid, ttl, hops, version, restOf);
        }
    }

    private static class UpdateResponseParser
    implements VendorMessageParser {
        private UpdateResponseParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new UpdateResponse(guid, ttl, hops, version, restOf);
        }
    }

    private static class UpdateRequestParser
    implements VendorMessageParser {
        private UpdateRequestParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new UpdateRequest(guid, ttl, hops, version, restOf);
        }
    }

    private static class HeadPongParser
    implements VendorMessageParser {
        private HeadPongParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new HeadPong(guid, ttl, hops, version, restOf);
        }
    }

    private static class HeadPingParser
    implements VendorMessageParser {
        private HeadPingParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new HeadPing(guid, ttl, hops, version, restOf);
        }
    }

    private static class UDPCrawlerPingParser
    implements VendorMessageParser {
        private UDPCrawlerPingParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new UDPCrawlerPing(guid, ttl, hops, version, restOf);
        }
    }

    private static class SimppVMParser
    implements VendorMessageParser {
        private SimppVMParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new SimppVM(guid, ttl, hops, version, restOf);
        }
    }

    private static class SimppRequestVMParser
    implements VendorMessageParser {
        private SimppRequestVMParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new SimppRequestVM(guid, ttl, hops, version, restOf);
        }
    }

    private static class StatisticVendorMessageParser
    implements VendorMessageParser {
        private StatisticVendorMessageParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new StatisticVendorMessage(guid, ttl, hops, version, restOf);
        }
    }

    private static class GiveStatsVendorMessageParser
    implements VendorMessageParser {
        private GiveStatsVendorMessageParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new GiveStatsVendorMessage(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class CapabilitiesVMParser
    implements VendorMessageParser {
        private CapabilitiesVMParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new CapabilitiesVM(guid, ttl, hops, version, restOf);
        }
    }

    private static class UDPConnectBackRedirectParser
    implements VendorMessageParser {
        private UDPConnectBackRedirectParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new UDPConnectBackRedirect(guid, ttl, hops, version, restOf);
        }
    }

    private static class TCPConnectBackRedirectParser
    implements VendorMessageParser {
        private TCPConnectBackRedirectParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new TCPConnectBackRedirect(guid, ttl, hops, version, restOf);
        }
    }

    private static class QueryStatusResponseParser
    implements VendorMessageParser {
        private QueryStatusResponseParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new QueryStatusResponse(guid, ttl, hops, version, restOf);
        }
    }

    private static class QueryStatusRequestParser
    implements VendorMessageParser {
        private QueryStatusRequestParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new QueryStatusRequest(guid, ttl, hops, version, restOf);
        }
    }

    private static class PushProxyAcknowledgementParser
    implements VendorMessageParser {
        private PushProxyAcknowledgementParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new PushProxyAcknowledgement(guid, ttl, hops, version, restOf);
        }
    }

    private static class PushProxyRequestParser
    implements VendorMessageParser {
        private PushProxyRequestParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new PushProxyRequest(guid, ttl, hops, version, restOf);
        }
    }

    private static class UDPConnectBackVendorMessageParser
    implements VendorMessageParser {
        private UDPConnectBackVendorMessageParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new UDPConnectBackVendorMessage(guid, ttl, hops, version, restOf);
        }
    }

    private static class MessagesSupportedVendorMessageParser
    implements VendorMessageParser {
        private MessagesSupportedVendorMessageParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new MessagesSupportedVendorMessage(guid, ttl, hops, version, restOf);
        }
    }

    private static class TCPConnectBackVendorMessageParser
    implements VendorMessageParser {
        private TCPConnectBackVendorMessageParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new TCPConnectBackVendorMessage(guid, ttl, hops, version, restOf);
        }
    }

    private static class ReplyNumberVendorMessageParser
    implements VendorMessageParser {
        private ReplyNumberVendorMessageParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new ReplyNumberVendorMessage(guid, ttl, hops, version, restOf);
        }
    }

    private static class LimeACKVendorMessageParser
    implements VendorMessageParser {
        private LimeACKVendorMessageParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new LimeACKVendorMessage(guid, ttl, hops, version, restOf);
        }
    }

    private static class HopsFlowVendorMessageParser
    implements VendorMessageParser {
        private HopsFlowVendorMessageParser() {
        }

        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, int network) throws BadPacketException {
            return new HopsFlowVendorMessage(guid, ttl, hops, version, restOf);
        }
    }

    public static interface VendorMessageParser {
        public VendorMessage parse(byte[] var1, byte var2, byte var3, int var4, byte[] var5, int var6) throws BadPacketException;
    }
}

