/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.util.IOUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class FLACMetaData
extends AudioMetaData {
    public static final String TITLE_TAG = "title";
    public static final String TRACK_TAG = "tracknumber";
    public static final String ALBUM_TAG = "album";
    public static final String GENRE_TAG = "genre";
    public static final String DATE_TAG = "date";
    public static final String COMMENT_TAG = "comment";
    public static final String ARTIST_TAG = "artist";
    public static final String LICENSE_TAG = "license";
    private static final byte FIRST_BIT = -128;

    public FLACMetaData(File f) throws IOException {
        super(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseFile(File file) throws IOException {
        DataInputStream dis;
        FileInputStream is;
        block3: {
            is = null;
            try {
                is = new FileInputStream(file);
                dis = new DataInputStream(is);
                if (this.readHeader(dis)) break block3;
            }
            catch (Throwable throwable) {
                IOUtils.close(is);
                throw throwable;
            }
            IOUtils.close(is);
            return;
        }
        Set comments = this.searchAndReadMetaData(dis);
        this.parseVorbisComment(comments);
        IOUtils.close(is);
    }

    private boolean readHeader(DataInputStream dis) throws IOException {
        return dis.readByte() == 102 && dis.readByte() == 76 && dis.readByte() == 97 && dis.readByte() == 67;
    }

    private Set searchAndReadMetaData(DataInputStream dis) throws IOException {
        HashSet ret = new HashSet();
        boolean shouldStop = false;
        do {
            byte[] blockHeader = new byte[4];
            dis.readFully(blockHeader);
            shouldStop = (blockHeader[0] & 0xFFFFFF80) != 0;
            byte type = (byte)(blockHeader[0] & 0x7F);
            int size = ByteOrder.beb2int(blockHeader, 1, 3);
            if (type == 4) {
                this.readVorbisComments(dis, ret);
                continue;
            }
            if (type == 0) {
                this.readStreamInfo(dis);
                continue;
            }
            IOUtils.ensureSkip(dis, size);
        } while (!shouldStop);
        return ret;
    }

    private void readStreamInfo(DataInputStream dis) throws IOException {
        IOUtils.ensureSkip(dis, 10L);
        byte[] info = new byte[8];
        dis.readFully(info);
        IOUtils.ensureSkip(dis, 16L);
        int sampleRate = ByteOrder.beb2int(info, 0, 3) >> 4;
        if (sampleRate <= 0) {
            throw new IOException("unreasonable sample rate!");
        }
        int numChannels = (ByteOrder.beb2int(info, 2, 1) >> 1 & 7) + 1;
        if (numChannels <= 0) {
            throw new IOException("unreasonable number of channels!");
        }
        int bitsPerSample = (ByteOrder.beb2int(info, 2, 2) >> 4 & 0x1F) + 1;
        long totalSamples = ByteOrder.beb2int(info, 3, 1) & 0xF;
        totalSamples <<= 32;
        this.setBitrate(bitsPerSample * sampleRate / 1024 * numChannels);
        this.setLength((int)((totalSamples |= (long)ByteOrder.beb2int(info, 4, 4)) / (long)sampleRate));
    }

    private void readVorbisComments(DataInputStream dis, Set comments) throws IOException {
        byte[] dword = new byte[4];
        dis.readFully(dword);
        int vendorStringSize = ByteOrder.leb2int(dword, 0);
        byte[] vendorString = new byte[vendorStringSize];
        dis.readFully(vendorString);
        dis.readFully(dword);
        int numComments = ByteOrder.leb2int(dword, 0);
        for (int i = 0; i < numComments; ++i) {
            dis.readFully(dword);
            int commentSize = ByteOrder.leb2int(dword, 0);
            byte[] comment = new byte[commentSize];
            dis.readFully(comment);
            comments.add(new String(comment, "UTF-8"));
        }
    }

    private void parseVorbisComment(Set comments) {
        Iterator iter = comments.iterator();
        while (iter.hasNext()) {
            String str = iter.next().toString();
            int index = str.indexOf(61);
            String key = str.substring(0, index);
            key = key.toLowerCase(Locale.US);
            String value = str.substring(index + 1);
            if (key.equals(TITLE_TAG)) {
                this.setTitle(value);
                continue;
            }
            if (key.equals(ARTIST_TAG)) {
                this.setArtist(value);
                continue;
            }
            if (key.equals(COMMENT_TAG)) {
                this.setComment(value);
                continue;
            }
            if (key.equals(ALBUM_TAG)) {
                this.setAlbum(value);
                continue;
            }
            if (key.equals(LICENSE_TAG)) {
                this.setLicense(value);
                continue;
            }
            if (key.equals(DATE_TAG)) {
                this.setYear(value.length() > 4 ? value.substring(0, 4) : value);
                continue;
            }
            if (!key.equals(TRACK_TAG)) continue;
            try {
                short track = Short.parseShort(value);
                this.setTrack(track);
            }
            catch (NumberFormatException ignored) {}
        }
    }
}

