/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.AudioMetaDataEditor;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.NoID3v2TagException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MP3DataEditor
extends AudioMetaDataEditor {
    private static final Log LOG = LogFactory.getLog(MP3DataEditor.class);
    private static final String ISO_LATIN_1 = "8859_1";
    private static final String UNICODE = "Unicode";
    static final String TITLE_ID = "TIT2";
    static final String ARTIST_ID = "TPE1";
    static final String ALBUM_ID = "TALB";
    static final String YEAR_ID = "TYER";
    static final String TRACK_ID = "TRCK";
    static final String COMMENT_ID = "COMM";
    static final String GENRE_ID = "TCON";
    static final String LICENSE_ID = "TCOP";

    private int writeID3V2DataToDisk(File file) throws IOException, ID3v2Exception {
        Iterator iter;
        ID3v2 id3Handler = new ID3v2(file);
        Vector frames = null;
        try {
            frames = (Vector)id3Handler.getFrames().clone();
        }
        catch (NoID3v2TagException ex) {
            // empty catch block
        }
        ArrayList framesToUpdate = new ArrayList();
        this.addAllNeededFrames(framesToUpdate);
        if (framesToUpdate.size() == 0) {
            return 0;
        }
        if (frames != null) {
            iter = frames.iterator();
            while (iter.hasNext()) {
                ID3v2Frame oldFrame = (ID3v2Frame)iter.next();
                int index = framesToUpdate.indexOf(oldFrame);
                ID3v2Frame newFrame = null;
                if (index >= 0) {
                    newFrame = (ID3v2Frame)framesToUpdate.remove(index);
                    if (Arrays.equals(oldFrame.getContent(), newFrame.getContent())) continue;
                }
                id3Handler.removeFrame(oldFrame);
                if (newFrame == null) continue;
                id3Handler.addFrame(newFrame);
            }
        }
        iter = framesToUpdate.iterator();
        while (iter.hasNext()) {
            ID3v2Frame frame = (ID3v2Frame)iter.next();
            id3Handler.addFrame(frame);
        }
        id3Handler.update();
        return 0;
    }

    private void addAllNeededFrames(List updateList) {
        this.add(updateList, this.title_, TITLE_ID);
        this.add(updateList, this.artist_, ARTIST_ID);
        this.add(updateList, this.album_, ALBUM_ID);
        this.add(updateList, this.year_, YEAR_ID);
        this.add(updateList, this.track_, TRACK_ID);
        this.add(updateList, this.comment_, COMMENT_ID);
        this.add(updateList, this.genre_, GENRE_ID);
        this.add(updateList, this.license_, LICENSE_ID);
    }

    private void add(List list, String data, String id) {
        if (data != null && !data.equals("")) {
            ID3v2Frame frame;
            if (id == GENRE_ID && this.getGenreByte() > -1) {
                data = "(" + this.getGenreByte() + ")" + data;
            }
            if ((frame = this.makeFrame(id, data)) != null) {
                list.add(frame);
            }
        }
    }

    private ID3v2Frame makeFrame(String frameID, String value) {
        boolean isISOLatin1 = true;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) <= '\u00ff') continue;
            isISOLatin1 = false;
            break;
        }
        try {
            return new ID3v2Frame(frameID, value.getBytes(isISOLatin1 ? ISO_LATIN_1 : UNICODE), true, true, false, 0, 0, 0, isISOLatin1);
        }
        catch (ID3v2DecompressionException cx) {
            return null;
        }
        catch (UnsupportedEncodingException err) {
            return null;
        }
    }

    private int writeID3V1DataToDisk(RandomAccessFile file) {
        byte[] buffer = new byte[30];
        String tag = "";
        try {
            file.readFully(buffer, 0, 3);
            tag = new String(buffer, 0, 3);
        }
        catch (EOFException e) {
            return 2;
        }
        catch (IOException e) {
            return 2;
        }
        if (!tag.equals("TAG")) {
            try {
                byte[] tagBytes = "TAG".getBytes();
                file.seek(file.length() - 128L);
                file.write(tagBytes, 0, 3);
            }
            catch (IOException ioe) {
                return 3;
            }
        }
        LOG.debug("about to start writing to file");
        boolean b = this.toFile(this.title_, 30, file, buffer);
        if (!b) {
            return 4;
        }
        b = this.toFile(this.artist_, 30, file, buffer);
        if (!b) {
            return 5;
        }
        b = this.toFile(this.album_, 30, file, buffer);
        if (!b) {
            return 6;
        }
        b = this.toFile(this.year_, 4, file, buffer);
        if (!b) {
            return 7;
        }
        b = this.toFile(this.comment_, 28, file, buffer);
        if (!b) {
            return 8;
        }
        int trackByte = -1;
        try {
            trackByte = this.track_ == null || this.track_.equals("") ? 0 : (int)Byte.parseByte(this.track_);
        }
        catch (NumberFormatException nfe) {
            return 9;
        }
        try {
            file.write(0);
            file.write(trackByte);
        }
        catch (IOException e) {
            return 9;
        }
        byte genreByte = this.getGenreByte();
        try {
            file.write(genreByte);
        }
        catch (IOException e) {
            return 10;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean toFile(String val, int maxLen, RandomAccessFile file, byte[] buffer) {
        void var5_5;
        byte[] fromString;
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing value to file " + val);
        }
        if (val == null || val.equals("")) {
            fromString = new byte[maxLen];
            Arrays.fill(fromString, 0, maxLen, (byte)0);
        } else {
            try {
                fromString = val.getBytes(ISO_LATIN_1);
            }
            catch (UnsupportedEncodingException err) {
                return false;
            }
        }
        int len = ((void)var5_5).length;
        if (len < maxLen) {
            System.arraycopy(var5_5, 0, buffer, 0, len);
            Arrays.fill(buffer, len, maxLen, (byte)0);
        } else {
            System.arraycopy(var5_5, 0, buffer, 0, maxLen);
        }
        try {
            file.write(buffer, 0, maxLen);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private byte getGenreByte() {
        if (this.genre_ == null) {
            return -1;
        }
        if (this.genre_.equals("Blues")) {
            return 0;
        }
        if (this.genre_.equals("Classic Rock")) {
            return 1;
        }
        if (this.genre_.equals("Country")) {
            return 2;
        }
        if (this.genre_.equals("Dance")) {
            return 3;
        }
        if (this.genre_.equals("Disco")) {
            return 4;
        }
        if (this.genre_.equals("Funk")) {
            return 5;
        }
        if (this.genre_.equals("Grunge")) {
            return 6;
        }
        if (this.genre_.equals("Hop")) {
            return 7;
        }
        if (this.genre_.equals("Jazz")) {
            return 8;
        }
        if (this.genre_.equals("Metal")) {
            return 9;
        }
        if (this.genre_.equals("New Age")) {
            return 10;
        }
        if (this.genre_.equals("Oldies")) {
            return 11;
        }
        if (this.genre_.equals("Other")) {
            return 12;
        }
        if (this.genre_.equals("Pop")) {
            return 13;
        }
        if (this.genre_.equals("R &amp; B")) {
            return 14;
        }
        if (this.genre_.equals("Rap")) {
            return 15;
        }
        if (this.genre_.equals("Reggae")) {
            return 16;
        }
        if (this.genre_.equals("Rock")) {
            return 17;
        }
        if (this.genre_.equals("Techno")) {
            return 17;
        }
        if (this.genre_.equals("Industrial")) {
            return 19;
        }
        if (this.genre_.equals("Alternative")) {
            return 20;
        }
        if (this.genre_.equals("Ska")) {
            return 21;
        }
        if (this.genre_.equals("Metal")) {
            return 22;
        }
        if (this.genre_.equals("Pranks")) {
            return 23;
        }
        if (this.genre_.equals("Soundtrack")) {
            return 24;
        }
        if (this.genre_.equals("Euro-Techno")) {
            return 25;
        }
        if (this.genre_.equals("Ambient")) {
            return 26;
        }
        if (this.genre_.equals("Trip-Hop")) {
            return 27;
        }
        if (this.genre_.equals("Vocal")) {
            return 28;
        }
        if (this.genre_.equals("Jazz+Funk")) {
            return 29;
        }
        if (this.genre_.equals("Fusion")) {
            return 30;
        }
        if (this.genre_.equals("Trance")) {
            return 31;
        }
        if (this.genre_.equals("Classical")) {
            return 32;
        }
        if (this.genre_.equals("Instrumental")) {
            return 33;
        }
        if (this.genre_.equals("Acid")) {
            return 34;
        }
        if (this.genre_.equals("House")) {
            return 35;
        }
        if (this.genre_.equals("Game")) {
            return 36;
        }
        if (this.genre_.equals("Sound Clip")) {
            return 37;
        }
        if (this.genre_.equals("Gospel")) {
            return 38;
        }
        if (this.genre_.equals("Noise")) {
            return 39;
        }
        if (this.genre_.equals("AlternRock")) {
            return 40;
        }
        if (this.genre_.equals("Bass")) {
            return 41;
        }
        if (this.genre_.equals("Soul")) {
            return 42;
        }
        if (this.genre_.equals("Punk")) {
            return 43;
        }
        if (this.genre_.equals("Space")) {
            return 44;
        }
        if (this.genre_.equals("Meditative")) {
            return 45;
        }
        if (this.genre_.equals("Instrumental Pop")) {
            return 46;
        }
        if (this.genre_.equals("Instrumental Rock")) {
            return 47;
        }
        if (this.genre_.equals("Ethnic")) {
            return 48;
        }
        if (this.genre_.equals("Gothic")) {
            return 49;
        }
        if (this.genre_.equals("Darkwave")) {
            return 50;
        }
        if (this.genre_.equals("Techno-Industrial")) {
            return 51;
        }
        if (this.genre_.equals("Electronic")) {
            return 52;
        }
        if (this.genre_.equals("Pop-Folk")) {
            return 53;
        }
        if (this.genre_.equals("Eurodance")) {
            return 54;
        }
        if (this.genre_.equals("Dream")) {
            return 55;
        }
        if (this.genre_.equals("Southern Rock")) {
            return 56;
        }
        if (this.genre_.equals("Comedy")) {
            return 57;
        }
        if (this.genre_.equals("Cult")) {
            return 58;
        }
        if (this.genre_.equals("Gangsta")) {
            return 59;
        }
        if (this.genre_.equals("Top 40")) {
            return 60;
        }
        if (this.genre_.equals("Christian Rap")) {
            return 61;
        }
        if (this.genre_.equals("Pop/Funk")) {
            return 62;
        }
        if (this.genre_.equals("Jungle")) {
            return 63;
        }
        if (this.genre_.equals("Native American")) {
            return 64;
        }
        if (this.genre_.equals("Cabaret")) {
            return 65;
        }
        if (this.genre_.equals("New Wave")) {
            return 66;
        }
        if (this.genre_.equals("Psychadelic")) {
            return 67;
        }
        if (this.genre_.equals("Rave")) {
            return 68;
        }
        if (this.genre_.equals("Showtunes")) {
            return 69;
        }
        if (this.genre_.equals("Trailer")) {
            return 70;
        }
        if (this.genre_.equals("Lo-Fi")) {
            return 71;
        }
        if (this.genre_.equals("Tribal")) {
            return 72;
        }
        if (this.genre_.equals("Acid Punk")) {
            return 73;
        }
        if (this.genre_.equals("Acid Jazz")) {
            return 74;
        }
        if (this.genre_.equals("Polka")) {
            return 75;
        }
        if (this.genre_.equals("Retro")) {
            return 76;
        }
        if (this.genre_.equals("Musical")) {
            return 77;
        }
        if (this.genre_.equals("Rock &amp; Roll")) {
            return 78;
        }
        if (this.genre_.equals("Hard Rock")) {
            return 79;
        }
        if (this.genre_.equals("Folk")) {
            return 80;
        }
        if (this.genre_.equals("Folk-Rock")) {
            return 81;
        }
        if (this.genre_.equals("National Folk")) {
            return 82;
        }
        if (this.genre_.equals("Swing")) {
            return 83;
        }
        if (this.genre_.equals("Fast Fusion")) {
            return 84;
        }
        if (this.genre_.equals("Bebob")) {
            return 85;
        }
        if (this.genre_.equals("Latin")) {
            return 86;
        }
        if (this.genre_.equals("Revival")) {
            return 87;
        }
        if (this.genre_.equals("Celtic")) {
            return 88;
        }
        if (this.genre_.equals("Bluegrass")) {
            return 89;
        }
        if (this.genre_.equals("Avantgarde")) {
            return 90;
        }
        if (this.genre_.equals("Gothic Rock")) {
            return 91;
        }
        if (this.genre_.equals("Progressive Rock")) {
            return 92;
        }
        if (this.genre_.equals("Psychedelic Rock")) {
            return 93;
        }
        if (this.genre_.equals("Symphonic Rock")) {
            return 94;
        }
        if (this.genre_.equals("Slow Rock")) {
            return 95;
        }
        if (this.genre_.equals("Big Band")) {
            return 96;
        }
        if (this.genre_.equals("Chorus")) {
            return 97;
        }
        if (this.genre_.equals("Easy Listening")) {
            return 98;
        }
        if (this.genre_.equals("Acoustic")) {
            return 99;
        }
        if (this.genre_.equals("Humour")) {
            return 100;
        }
        if (this.genre_.equals("Speech")) {
            return 101;
        }
        if (this.genre_.equals("Chanson")) {
            return 102;
        }
        if (this.genre_.equals("Opera")) {
            return 103;
        }
        if (this.genre_.equals("Chamber Music")) {
            return 104;
        }
        if (this.genre_.equals("Sonata")) {
            return 105;
        }
        if (this.genre_.equals("Symphony")) {
            return 106;
        }
        if (this.genre_.equals("Booty Bass")) {
            return 107;
        }
        if (this.genre_.equals("Primus")) {
            return 108;
        }
        if (this.genre_.equals("Porn Groove")) {
            return 109;
        }
        if (this.genre_.equals("Satire")) {
            return 110;
        }
        if (this.genre_.equals("Slow Jam")) {
            return 111;
        }
        if (this.genre_.equals("Club")) {
            return 112;
        }
        if (this.genre_.equals("Tango")) {
            return 113;
        }
        if (this.genre_.equals("Samba")) {
            return 114;
        }
        if (this.genre_.equals("Folklore")) {
            return 115;
        }
        if (this.genre_.equals("Ballad")) {
            return 116;
        }
        if (this.genre_.equals("Power Ballad")) {
            return 117;
        }
        if (this.genre_.equals("Rhythmic Soul")) {
            return 118;
        }
        if (this.genre_.equals("Freestyle")) {
            return 119;
        }
        if (this.genre_.equals("Duet")) {
            return 120;
        }
        if (this.genre_.equals("Punk Rock")) {
            return 121;
        }
        if (this.genre_.equals("Drum Solo")) {
            return 122;
        }
        if (this.genre_.equals("A capella")) {
            return 123;
        }
        if (this.genre_.equals("Euro-House")) {
            return 124;
        }
        if (this.genre_.equals("Dance Hall")) {
            return 125;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int commitMetaData(String filename) {
        block22: {
            block21: {
                if (MP3DataEditor.LOG.isDebugEnabled()) {
                    MP3DataEditor.LOG.debug("committing mp3 file");
                }
                if (!LimeXMLUtils.isMP3File(filename)) {
                    return 12;
                }
                f = null;
                file = null;
                try {
                    try {
                        f = new File(filename);
                        FileUtils.setWriteable(f);
                        file = new RandomAccessFile(f, "rw");
                    }
                    catch (IOException e) {
                        var5_6 = 1;
                        var10_7 = null;
                        if (file == null) return var5_6;
                        try {
                            file.close();
                            return var5_6;
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                        return var5_6;
                    }
                    length = 0L;
                    try {
                        length = file.length();
                        if (length < 128L) {
                            var6_19 = 1;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (IOException ee) {
                        var7_22 = 2;
                        var10_9 = null;
                        if (file == null) return var7_22;
                        ** try [egrp 5[TRYBLOCK] [11 : 182->189)] { 
lbl38:
                        // 1 sources

                        file.close();
                        return var7_22;
lbl40:
                        // 1 sources

                        catch (IOException ignored) {
                            // empty catch block
                        }
                        return var7_22;
                    }
                    var10_8 = null;
                    if (file == null) return var6_19;
                    break block21;
lbl-1000:
                    // 1 sources

                    {
                        file.seek(length - 128L);
                    }
                    ret = -1;
                    try {
                        ret = this.writeID3V2DataToDisk(f);
                    }
                    catch (IOException iox) {
                        var8_26 = 2;
                        var10_10 = null;
                        if (file == null) return var8_26;
                        ** try [egrp 5[TRYBLOCK] [11 : 182->189)] { 
lbl57:
                        // 1 sources

                        file.close();
                        return var8_26;
lbl59:
                        // 1 sources

                        catch (IOException ignored) {
                            // empty catch block
                        }
                        return var8_26;
                    }
                    catch (ID3v2Exception e) {
                        ret = this.writeID3V1DataToDisk(file);
                    }
                    var7_25 = ret;
                    break block22;
                }
                catch (Throwable var9_27) {
                    var10_12 = null;
                    if (file == null) throw var9_27;
                    try {}
                    catch (IOException ignored) {
                        throw var9_27;
                    }
                    file.close();
                    throw var9_27;
                }
            }
            try {}
            catch (IOException ignored) {
                // empty catch block
                return var6_19;
            }
            file.close();
            return var6_19;
        }
        var10_11 = null;
        if (file == null) return var7_25;
        ** try [egrp 5[TRYBLOCK] [11 : 182->189)] { 
lbl87:
        // 1 sources

        file.close();
        return var7_25;
lbl89:
        // 1 sources

        catch (IOException ignored) {
            // empty catch block
        }
        return var7_25;
    }
}

