/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.AudioMetaDataEditor;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MetaDataEditor {
    private Log LOG = LogFactory.getLog(MetaDataEditor.class);
    protected LimeXMLDocument correctDocument = null;

    protected MetaDataEditor() {
    }

    protected boolean matches(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public abstract boolean betterThan(MetaDataEditor var1);

    protected boolean firstBetter(String first, String second) {
        if (first == null && second == null) {
            return true;
        }
        if (first != null && first.equals(second)) {
            return true;
        }
        return first != null && !"".equals(first);
    }

    public abstract void pickBetterFields(MetaDataEditor var1);

    public abstract int commitMetaData(String var1);

    public abstract void populate(LimeXMLDocument var1);

    public void setCorrectDocument(LimeXMLDocument document) {
        this.correctDocument = document;
    }

    public LimeXMLDocument getCorrectDocument() {
        return this.correctDocument;
    }

    public static MetaDataEditor getEditorForFile(String name) {
        if (LimeXMLUtils.isSupportedAudioFormat(name)) {
            return AudioMetaDataEditor.getEditorForFile(name);
        }
        return null;
    }
}

