/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.metadata.VideoMetaData;
import com.limegroup.gnutella.util.IOUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class RIFFMetaData
extends VideoMetaData {
    public RIFFMetaData(File f) throws IOException {
        super(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseFile(File f) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            DataInputStream dis = new DataInputStream(is);
            this.readRIFFHeader(dis);
        }
        catch (Throwable throwable) {
            IOUtils.close(is);
            throw throwable;
        }
        IOUtils.close(is);
    }

    private void readRIFFHeader(DataInputStream dis) throws IOException {
        byte[] dword = new byte[4];
        dis.readFully(dword);
        if (dword[0] != 82 || dword[1] != 73 || dword[2] != 70 || dword[3] != 70) {
            return;
        }
        IOUtils.ensureSkip(dis, 4L);
        dis.readFully(dword);
        if (dword[0] != 65 || dword[1] != 86 || dword[2] != 73 || dword[3] != 32) {
            return;
        }
        IOUtils.ensureSkip(dis, 12L);
        IOUtils.ensureSkip(dis, 8L);
        dis.readFully(dword);
        int microsPerFrame = ByteOrder.leb2int(dword, 0, 4);
        IOUtils.ensureSkip(dis, 12L);
        dis.readFully(dword);
        int totalFrames = ByteOrder.leb2int(dword, 0, 4);
        this.setLength((short)(1L * (long)microsPerFrame * (long)totalFrames / 1000L));
        IOUtils.ensureSkip(dis, 4L);
        dis.readFully(dword);
        int numStreams = ByteOrder.leb2int(dword, 0, 4);
        IOUtils.ensureSkip(dis, 4L);
        dis.readFully(dword);
        this.setWidth(ByteOrder.leb2int(dword, 0, 4));
        dis.readFully(dword);
        this.setHeight(ByteOrder.leb2int(dword, 0, 4));
        IOUtils.ensureSkip(dis, 16L);
    }
}

