/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.Setting;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class FileSetSetting
extends Setting {
    private Set value;

    FileSetSetting(Properties defaultProps, Properties props, String key, File[] defaultValue) {
        this(defaultProps, props, key, defaultValue, null);
    }

    FileSetSetting(Properties defaultProps, Properties props, String key, File[] defaultValue, String simppKey) {
        super(defaultProps, props, key, FileSetSetting.decode(new HashSet<File>(Arrays.asList(defaultValue))), simppKey);
        this.setPrivate(true);
    }

    public Set getValue() {
        return this.value;
    }

    public synchronized File[] getValueAsArray() {
        return this.value.toArray(new File[this.value.size()]);
    }

    public void setValue(Set value) {
        super.setValue(FileSetSetting.decode(value));
    }

    public synchronized void add(File file) {
        this.value.add(file);
        this.setValue(this.value);
    }

    public synchronized boolean remove(File file) {
        if (this.value.remove(file)) {
            this.setValue(this.value);
            return true;
        }
        return false;
    }

    public synchronized boolean contains(File file) {
        return this.value.contains(file);
    }

    public synchronized int length() {
        return this.value.size();
    }

    protected synchronized void loadValue(String sValue) {
        this.value = FileSetSetting.encode(sValue);
    }

    private static final Set encode(String src) {
        if (src == null || src.length() == 0) {
            return new HashSet();
        }
        StringTokenizer tokenizer = new StringTokenizer(src, ";");
        int size = tokenizer.countTokens();
        HashSet<File> set = new HashSet<File>();
        for (int i = 0; i < size; ++i) {
            set.add(new File(tokenizer.nextToken()));
        }
        return set;
    }

    private static final String decode(Set src) {
        if (src == null || src.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator i = src.iterator();
        while (i.hasNext()) {
            buffer.append(((File)i.next()).getAbsolutePath());
            if (!i.hasNext()) continue;
            buffer.append(';');
        }
        return buffer.toString();
    }

    public synchronized void clean() {
        Iterator i = this.value.iterator();
        while (i.hasNext()) {
            File next = (File)i.next();
            if (next.exists()) continue;
            i.remove();
        }
        this.setValue(this.value);
    }
}

