/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.updates;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.updates.UpdateFileParser;
import com.limegroup.gnutella.updates.UpdateMessageVerifier;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class UpdateManager {
    private static final Log LOG = LogFactory.getLog(UpdateManager.class);
    private String latestVersion = "0.0.0";
    private String message = "";
    private boolean usesLocale;
    private static UpdateManager INSTANCE = null;
    public static final String SPECIAL_VERSION = "@version@";
    private boolean isValid;

    private UpdateManager() {
        UpdateMessageVerifier verifier;
        boolean verified;
        byte[] content = FileUtils.readFileFully(new File(CommonUtils.getUserSettingsDir(), "update.xml"));
        if (content != null && (verified = (verifier = new UpdateMessageVerifier(content, true)).verifySource())) {
            try {
                String xml = new String(verifier.getMessageBytes(), "UTF-8");
                UpdateFileParser parser = new UpdateFileParser(xml);
                this.latestVersion = parser.getVersion();
                this.message = parser.getMessage();
                this.usesLocale = parser.usesLocale();
                this.isValid = true;
            }
            catch (SAXException sax) {
                LOG.error("invalid update xml", sax);
            }
            catch (IOException iox) {
                LOG.error("iox updating", iox);
            }
        }
    }

    public static synchronized UpdateManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new UpdateManager();
        }
        return INSTANCE;
    }

    public synchronized String getVersion() {
        Assert.that(this.latestVersion != null, "version not initilaized");
        return this.latestVersion;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void checkAndUpdate(Connection connection) {
        String nv = connection.getVersion();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Update check: myVersion: " + this.latestVersion + ", theirs: " + nv);
        }
        String myVersion = null;
        myVersion = this.latestVersion.equals(SPECIAL_VERSION) ? "0.0.0" : this.latestVersion;
        if (!UpdateManager.isGreaterVersion(nv, myVersion)) {
            return;
        }
        if (nv.equals(SPECIAL_VERSION)) {
            return;
        }
        final Connection c = connection;
        final String myversion = myVersion;
        ThreadFactory.startThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block23: {
                    LOG.trace("Getting update file");
                    String UPDATE = "/update.xml";
                    String ip = c.getAddress();
                    int port = c.getPort();
                    String connectTo = "http://" + ip + ":" + port + "/update.xml";
                    HttpClient client = HttpClientManager.getNewClient();
                    GetMethod get = new GetMethod(connectTo);
                    get.addRequestHeader("Cache-Control", "no-cache");
                    get.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
                    get.addRequestHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
                    try {
                        String newVersion;
                        client.executeMethod(get);
                        byte[] data = get.getResponseBody();
                        if (data == null) {
                            return;
                        }
                        UpdateMessageVerifier verifier = new UpdateMessageVerifier(data, false);
                        boolean verified = false;
                        try {
                            verified = verifier.verifySource();
                        }
                        catch (ClassCastException ccx) {
                            verified = false;
                        }
                        if (!verified) {
                            return;
                        }
                        LOG.trace("Verified file contents");
                        String xml = new String(verifier.getMessageBytes(), "UTF-8");
                        UpdateFileParser parser = new UpdateFileParser(xml);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("New version: " + parser.getVersion());
                        }
                        if ((newVersion = parser.getVersion()) == null) {
                            return;
                        }
                        if (!UpdateManager.isGreaterVersion(newVersion, myversion)) break block23;
                        LOG.trace("committing new update file");
                        UpdateManager updateManager = UpdateManager.this;
                        synchronized (updateManager) {
                            UpdateManager.this.commitVersionFile(data);
                            UpdateManager.this.latestVersion = newVersion;
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("commited file. Latest is:" + UpdateManager.this.latestVersion);
                            }
                        }
                    }
                    catch (IOException iox) {
                        LOG.warn("iox on network, on disk, who knows??", iox);
                        return;
                    }
                    catch (SAXException sx) {
                        LOG.error("invalid xml", sx);
                        return;
                    }
                    catch (Throwable t) {
                        ErrorService.error(t);
                    }
                    finally {
                        if (get != null) {
                            get.releaseConnection();
                        }
                    }
                }
            }
        }, "UpdateFileRequestor");
    }

    public static boolean isGreaterVersion(String newVer, String oldVer) {
        int n1;
        int o1;
        if (newVer == null && oldVer == null) {
            return false;
        }
        if (newVer == null) {
            return false;
        }
        if (oldVer == null) {
            return true;
        }
        if (newVer.equals(oldVer)) {
            return false;
        }
        if (newVer.equals(SPECIAL_VERSION)) {
            return true;
        }
        if (oldVer.equals(SPECIAL_VERSION)) {
            return false;
        }
        int o2 = -1;
        int n2 = -1;
        try {
            StringTokenizer tokenizer = new StringTokenizer(oldVer, ".");
            if (tokenizer.countTokens() < 2) {
                return false;
            }
            o1 = new Integer(tokenizer.nextToken());
            o2 = new Integer(tokenizer.nextToken());
            tokenizer = new StringTokenizer(newVer, ".");
            if (tokenizer.countTokens() < 2) {
                return false;
            }
            n1 = new Integer(tokenizer.nextToken());
            n2 = new Integer(tokenizer.nextToken());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        if (n1 > o1) {
            return true;
        }
        return n1 == o1 && n2 > o2;
    }

    private void commitVersionFile(byte[] data) throws IOException {
        boolean ret = FileUtils.verySafeSave(CommonUtils.getUserSettingsDir(), "update.xml", data);
        if (!ret) {
            throw new IOException("couldn't safely save!");
        }
    }
}

