/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.IpPort;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;

public abstract class UploadState
implements HTTPMessage {
    protected final HTTPUploader UPLOADER;
    protected final FileDesc FILE_DESC;

    public UploadState() {
        this(null);
    }

    public UploadState(HTTPUploader uploader) {
        this.UPLOADER = uploader;
        this.FILE_DESC = uploader != null ? uploader.getFileDesc() : null;
    }

    protected void writeAlts(Writer os) throws IOException {
        URN sha1;
        if (this.FILE_DESC != null && (sha1 = this.FILE_DESC.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)sha1, os);
            Set alts = this.UPLOADER.getNextSetOfAltsToSend();
            if (alts.size() > 0) {
                HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(alts), os);
            }
            if (this.UPLOADER.wantsFAlts() && (alts = this.UPLOADER.getNextSetOfPushAltsToSend()).size() > 0) {
                HTTPUtils.writeHeader(HTTPHeaderName.FALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(alts), os);
            }
        }
    }

    protected void writeAlts(OutputStream os) throws IOException {
        URN sha1;
        if (this.FILE_DESC != null && (sha1 = this.FILE_DESC.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)sha1, os);
            Set alts = this.UPLOADER.getNextSetOfAltsToSend();
            if (alts.size() > 0) {
                HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(alts), os);
            }
            if (this.UPLOADER.wantsFAlts() && (alts = this.UPLOADER.getNextSetOfPushAltsToSend()).size() > 0) {
                HTTPUtils.writeHeader(HTTPHeaderName.FALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(alts), os);
            }
        }
    }

    protected void writeRanges(Writer os) throws IOException {
        URN sha1;
        if (this.FILE_DESC != null && this.FILE_DESC instanceof IncompleteFileDesc && (sha1 = this.FILE_DESC.getSHA1Urn()) != null) {
            IncompleteFileDesc iFILE_DESC = (IncompleteFileDesc)this.FILE_DESC;
            HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)iFILE_DESC, os);
        }
    }

    protected void writeRanges(OutputStream os) throws IOException {
        URN sha1;
        if (this.FILE_DESC != null && this.FILE_DESC instanceof IncompleteFileDesc && (sha1 = this.FILE_DESC.getSHA1Urn()) != null) {
            IncompleteFileDesc iFILE_DESC = (IncompleteFileDesc)this.FILE_DESC;
            HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)iFILE_DESC, os);
        }
    }

    protected void writeProxies(Writer os) throws IOException {
        int proxiesWritten;
        if (RouterService.acceptedIncomingConnection()) {
            return;
        }
        Set proxies = RouterService.getConnectionManager().getPushProxies();
        StringBuffer buf = new StringBuffer();
        Iterator iter = proxies.iterator();
        for (proxiesWritten = 0; iter.hasNext() && proxiesWritten < 4; ++proxiesWritten) {
            IpPort current = (IpPort)iter.next();
            buf.append(current.getAddress()).append(":").append(current.getPort()).append(",");
        }
        if (proxiesWritten <= 0) {
            return;
        }
        buf.deleteCharAt(buf.length() - 1);
        HTTPUtils.writeHeader(HTTPHeaderName.PROXIES, buf.toString(), os);
    }

    protected void writeProxies(OutputStream os) throws IOException {
        int proxiesWritten;
        if (RouterService.acceptedIncomingConnection()) {
            return;
        }
        Set proxies = RouterService.getConnectionManager().getPushProxies();
        StringBuffer buf = new StringBuffer();
        Iterator iter = proxies.iterator();
        for (proxiesWritten = 0; iter.hasNext() && proxiesWritten < 4; ++proxiesWritten) {
            IpPort current = (IpPort)iter.next();
            buf.append(current.getAddress()).append(":").append(current.getPort()).append(",");
        }
        if (proxiesWritten <= 0) {
            return;
        }
        buf.deleteCharAt(buf.length() - 1);
        HTTPUtils.writeHeader(HTTPHeaderName.PROXIES, buf.toString(), os);
    }
}

