/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class BufferByteArrayOutputStream
extends ByteArrayOutputStream {
    protected ByteBuffer buffer;
    protected boolean grow;

    public BufferByteArrayOutputStream() {
        this(32);
    }

    public BufferByteArrayOutputStream(int size) {
        this(ByteBuffer.allocate(size), true);
    }

    public BufferByteArrayOutputStream(int size, boolean grow) {
        this(ByteBuffer.allocate(size), grow);
    }

    public BufferByteArrayOutputStream(byte[] backing) {
        this(ByteBuffer.wrap(backing), false);
    }

    public BufferByteArrayOutputStream(byte[] backing, int pos, int length) {
        this(ByteBuffer.wrap(backing, pos, length), false);
    }

    public BufferByteArrayOutputStream(ByteBuffer backing) {
        this(backing, false);
    }

    public BufferByteArrayOutputStream(ByteBuffer backing, boolean grow) {
        this.buffer = backing;
        this.grow = grow;
    }

    public void close() throws IOException {
    }

    public void reset() {
        this.buffer.clear();
    }

    public int size() {
        return this.buffer.position();
    }

    public byte[] toByteArray() {
        byte[] arr = this.buffer.array();
        int offset = this.buffer.arrayOffset();
        int position = this.buffer.position();
        if (offset == 0 && position == arr.length) {
            return arr;
        }
        byte[] out = new byte[position];
        System.arraycopy(arr, offset, out, 0, position);
        return out;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public void writeTo(ByteBuffer sink) {
        this.buffer.flip();
        sink.put(this.buffer);
        this.buffer.compact();
    }

    public void writeTo(byte[] out) {
        this.writeTo(out, 0, out.length);
    }

    public void writeTo(byte[] out, int off, int len) {
        this.buffer.flip();
        this.buffer.get(out, off, len);
        this.buffer.compact();
    }

    public String toString() {
        return new String(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.position());
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        return new String(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.position(), encoding);
    }

    private void grow(int len) {
        int size = this.buffer.capacity();
        int newSize = Math.max(size << 1, size + len);
        ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }

    public void write(byte[] b, int off, int len) {
        if (this.grow && len > this.buffer.remaining()) {
            this.grow(len);
        }
        this.buffer.put(b, off, len);
    }

    public void write(int b) {
        if (this.grow && !this.buffer.hasRemaining()) {
            this.grow(1);
        }
        this.buffer.put((byte)b);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.position());
        this.buffer.clear();
    }
}

