/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.util.Stack;

public class ByteArrayCache {
    private static final int DEFAULT_SIZE = 512;
    private static final int DEFAULT_LENGTH = 1024;
    private final Stack CACHE = new Stack();
    private int _totalSize;
    private int _numCreated;
    private int _maxSize;
    private int _length;

    public ByteArrayCache() {
        this(512, 1024);
    }

    public ByteArrayCache(int maxSize, int length) {
        this._maxSize = maxSize;
        this._length = length;
        this.CACHE.ensureCapacity(maxSize);
    }

    public synchronized int getCacheSize() {
        return this._totalSize;
    }

    public synchronized byte[] get() throws InterruptedException {
        while (true) {
            if (!this.CACHE.isEmpty()) {
                byte[] b = (byte[])this.CACHE.pop();
                this._totalSize -= b.length;
                return b;
            }
            if (this._numCreated < this._maxSize) {
                ++this._numCreated;
                return new byte[this._length];
            }
            this.wait();
        }
    }

    public synchronized byte[] getQuick() {
        if (!this.CACHE.isEmpty()) {
            byte[] b = (byte[])this.CACHE.pop();
            this._totalSize -= b.length;
            return b;
        }
        if (this._numCreated < this._maxSize) {
            ++this._numCreated;
            return new byte[this._length];
        }
        return null;
    }

    public synchronized void release(byte[] data) {
        this._totalSize += data.length;
        this.CACHE.push(data);
        this.notifyAll();
    }

    public synchronized void clear() {
        this._numCreated -= this.CACHE.size();
        this._totalSize = 0;
        this.CACHE.clear();
        this.notifyAll();
    }

    public synchronized boolean isBufferAvailable() {
        return !this.CACHE.isEmpty() || this._numCreated < this._maxSize;
    }

    public synchronized int getCreated() {
        return this._numCreated;
    }

    public int getLength() {
        return this._length;
    }

    public int getMaxSize() {
        return this._maxSize;
    }
}

