/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.SystemUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMap(String filename, Map map) throws IOException, ClassNotFoundException {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(filename));
            out.writeObject(map);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readMap(String filename) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(filename));
            Map map = (Map)in.readObject();
            return map;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String getCanonicalPath(File f) throws IOException {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (CommonUtils.isWindows() && msg != null && msg.indexOf("There are no more files") != -1) {
                return f.getAbsolutePath();
            }
            throw ioe;
        }
    }

    public static File getCanonicalFile(File f) throws IOException {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (CommonUtils.isWindows() && msg != null && msg.indexOf("There are no more files") != -1) {
                return f.getAbsoluteFile();
            }
            throw ioe;
        }
    }

    public static final boolean isReallyParent(File testParent, File testChild) throws IOException {
        String testChildParentName;
        String testParentName = FileUtils.getCanonicalPath(testParent);
        return testParentName.equals(testChildParentName = FileUtils.getCanonicalPath(testChild.getAbsoluteFile().getParentFile()));
    }

    public static String getFileExtension(File f) {
        String name = f.getName();
        return FileUtils.getFileExtension(name);
    }

    public static String getFileExtension(String name) {
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        if (index == 0) {
            return null;
        }
        if (index == name.length() - 1) {
            return null;
        }
        return name.substring(index + 1);
    }

    public static boolean setWriteable(File f) {
        String fName;
        if (!f.exists()) {
            return true;
        }
        if (f.canWrite()) {
            if (CommonUtils.isWindows()) {
                return true;
            }
            if (!f.isDirectory()) {
                return true;
            }
        }
        try {
            fName = f.getCanonicalPath();
        }
        catch (IOException ioe) {
            fName = f.getPath();
        }
        String[] cmds = null;
        if (CommonUtils.isWindows() || CommonUtils.isMacOSX()) {
            SystemUtils.setWriteable(fName);
        } else {
            cmds = CommonUtils.isOS2() ? null : (f.isDirectory() ? new String[]{"chmod", "u+w+x", fName} : new String[]{"chmod", "u+w", fName});
        }
        if (cmds != null) {
            try {
                Process p = Runtime.getRuntime().exec(cmds);
                p.waitFor();
            }
            catch (SecurityException ignored) {
            }
            catch (IOException ignored) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return f.canWrite();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void touch(File f) throws IOException {
        if (f.exists()) {
            return;
        }
        File parent = f.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            f.createNewFile();
            return;
        }
        catch (IOException failed) {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(f);
                }
                catch (IOException ioe) {
                    ioe.initCause(failed);
                    throw ioe;
                }
                Object var6_4 = null;
                if (fos == null) return;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignored) {}
            fos.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean forceRename(File a, File b) {
        FileDesc fd;
        boolean success = a.renameTo(b);
        if (!success && (fd = RouterService.getFileManager().getFileDescForFile(a)) != null) {
            UploadManager upMan;
            UploadManager uploadManager = upMan = RouterService.getUploadManager();
            synchronized (uploadManager) {
                if (upMan.killUploadsForFileDesc(fd)) {
                    success = a.renameTo(b);
                }
            }
        }
        if (!success && (success = CommonUtils.copy(a, b))) {
            a.delete();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verySafeSave(File dir, String name, byte[] data) {
        File tmp;
        try {
            tmp = File.createTempFile(name, "tmp", dir);
        }
        catch (IOException hrorible) {
            return false;
        }
        File out = new File(dir, name);
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(tmp));
            ((OutputStream)os).write(data);
            ((OutputStream)os).flush();
            IOUtils.close(os);
        }
        catch (IOException bad) {
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.close(os);
        }
        byte[] read = FileUtils.readFileFully(tmp);
        if (read == null || !Arrays.equals(read, data)) {
            return false;
        }
        return FileUtils.forceRename(tmp, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileFully(File source) {
        DataInputStream raf = null;
        int length = (int)source.length();
        if (length <= 0) {
            return null;
        }
        byte[] data = new byte[length];
        try {
            raf = new DataInputStream(new BufferedInputStream(new FileInputStream(source)));
            raf.readFully(data);
            IOUtils.close(raf);
        }
        catch (IOException ioe) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.close(raf);
        }
        return data;
    }

    public static File[] getFilesRecursive(File directory, String[] filter) {
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> retFileArray = new ArrayList<File>();
        File[] retArray = new File[]{};
        if (directory.exists() && directory.isDirectory()) {
            dirs.add(directory);
        }
        while (dirs.size() > 0) {
            File currDir = (File)dirs.remove(0);
            String[] listedFiles = currDir.list();
            for (int i = 0; listedFiles != null && i < listedFiles.length; ++i) {
                File currFile = new File(currDir, listedFiles[i]);
                if (currFile.isDirectory()) {
                    dirs.add(currFile);
                    continue;
                }
                if (!currFile.isFile()) continue;
                boolean shouldAdd = false;
                if (filter == null) {
                    shouldAdd = true;
                } else {
                    String ext = FileUtils.getFileExtension(currFile);
                    for (int j = 0; j < filter.length && ext != null; ++j) {
                        if (!ext.equalsIgnoreCase(filter[j])) continue;
                        shouldAdd = true;
                        break;
                    }
                }
                if (!shouldAdd) continue;
                retFileArray.add(currFile);
            }
        }
        if (!retFileArray.isEmpty()) {
            retArray = new File[retFileArray.size()];
            for (int i = 0; i < retArray.length; ++i) {
                retArray[i] = (File)retFileArray.get(i);
            }
        }
        return retArray;
    }
}

