/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.downloader.Interval;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IntervalSet {
    private final List intervals = new ArrayList();

    public static IntervalSet createSingletonSet(long lowBound, long highBound) {
        IntervalSet ret = new IntervalSet();
        ret.add(new Interval(lowBound, highBound));
        return ret;
    }

    public void add(Interval addInterval) {
        int low = addInterval.low;
        int high = addInterval.high;
        Interval lower = null;
        Interval higher = null;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval interval = (Interval)iter.next();
            if (low <= interval.low && interval.high <= high) {
                iter.remove();
                continue;
            }
            if (low >= interval.low && interval.high >= high) {
                return;
            }
            if (low <= interval.high + 1 && interval.low < low) {
                lower = interval;
            }
            if (interval.low - 1 <= high && interval.high > high) {
                higher = interval;
            }
            if (higher == null && interval.low <= high) continue;
            break;
        }
        if (lower == null && higher == null) {
            this.addImpl(new Interval(low, high));
        } else if (lower != null && higher != null) {
            this.removeImpl(higher);
            this.removeImpl(lower);
            this.addImpl(new Interval(lower.low, higher.high));
        } else if (higher != null) {
            this.removeImpl(higher);
            this.addImpl(new Interval(low, higher.high));
        } else {
            this.removeImpl(lower);
            this.addImpl(new Interval(lower.low, high));
        }
    }

    public void add(IntervalSet set) {
        Iterator iter = set.getAllIntervals();
        while (iter.hasNext()) {
            this.add((Interval)iter.next());
        }
    }

    public void delete(Interval deleteMe) {
        int low = deleteMe.low;
        int high = deleteMe.high;
        Interval lower = null;
        Interval higher = null;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval interval = (Interval)iter.next();
            if (interval.high >= low && interval.low <= high) {
                iter.remove();
                if (interval.high <= high) {
                    if (interval.low >= low) continue;
                    lower = new Interval(interval.low, low - 1);
                    continue;
                }
                if (interval.low >= low) {
                    higher = new Interval(high + 1, interval.high);
                    break;
                }
                lower = new Interval(interval.low, low - 1);
                higher = new Interval(high + 1, interval.high);
                break;
            }
            if (interval.low < high) continue;
            break;
        }
        if (lower != null) {
            this.add(lower);
        }
        if (higher != null) {
            this.add(higher);
        }
    }

    public void delete(IntervalSet set) {
        Iterator iter = set.getAllIntervals();
        while (iter.hasNext()) {
            this.delete((Interval)iter.next());
        }
    }

    public Interval getFirst() throws NoSuchElementException {
        if (this.intervals.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (Interval)this.intervals.get(0);
    }

    public Interval getLast() throws NoSuchElementException {
        if (this.intervals.isEmpty()) {
            throw new NoSuchElementException();
        }
        Interval ret = (Interval)this.intervals.get(this.intervals.size() - 1);
        return ret;
    }

    public int getNumberOfIntervals() {
        return this.intervals.size();
    }

    public boolean contains(Interval i) {
        Iterator iter = this.getAllIntervals();
        while (iter.hasNext()) {
            Interval ours = (Interval)iter.next();
            if (ours.low > i.low || ours.high < i.high) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(Interval i) {
        int low = i.low;
        int high = i.high;
        Iterator iter = this.getAllIntervals();
        while (iter.hasNext()) {
            Interval interval = (Interval)iter.next();
            if (low <= interval.low && interval.high <= high) {
                return true;
            }
            if (low >= interval.low && interval.high >= high) {
                return true;
            }
            if (low <= interval.high + 1 && interval.low < low) {
                return true;
            }
            if (interval.low - 1 > high || interval.high <= high) continue;
            return true;
        }
        return false;
    }

    public List getOverlapIntervals(Interval checkInterval) {
        ArrayList<Interval> overlapBlocks = new ArrayList<Interval>();
        long low = checkInterval.low;
        long high = checkInterval.high;
        if (low > high) {
            return overlapBlocks;
        }
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval interval = (Interval)iter.next();
            if (low <= (long)interval.low && (long)interval.high <= high) {
                overlapBlocks.add(interval);
                continue;
            }
            if (low <= (long)interval.high && (long)interval.low < low) {
                overlapBlocks.add(new Interval(low, Math.min(high, (long)interval.high)));
            }
            if ((long)interval.low > high || (long)interval.high <= high) continue;
            overlapBlocks.add(new Interval(Math.max((long)interval.low, low), high));
        }
        return overlapBlocks;
    }

    public Iterator getAllIntervals() {
        return this.intervals.iterator();
    }

    public List getAllIntervalsAsList() {
        return new ArrayList(this.intervals);
    }

    public int getSize() {
        int sum = 0;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval block = (Interval)iter.next();
            sum += block.high - block.low + 1;
        }
        return sum;
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public void clear() {
        this.intervals.clear();
    }

    public IntervalSet invert(int maxSize) {
        IntervalSet ret = new IntervalSet();
        if (maxSize < 1) {
            return ret;
        }
        if (this.intervals.size() == 0) {
            Interval block = new Interval(0L, maxSize - 1);
            ret.add(block);
            return ret;
        }
        int low = -1;
        Interval interval = null;
        boolean fixed = false;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            interval = (Interval)iter.next();
            if (interval.low != 0 && low < interval.low) {
                if (low + 1 > interval.low - 1) {
                    if (!fixed) {
                        fixed = true;
                        this.fix();
                        iter = this.intervals.iterator();
                        low = -1;
                        interval = null;
                        continue;
                    }
                    throw new IllegalArgumentException("constructing invalid interval  while trying to invert \n" + this.toString() + " \n with size " + maxSize + " low:" + low + " interval.low:" + interval.low);
                }
                ret.add(new Interval(low + 1, interval.low - 1));
            }
            low = interval.high;
        }
        Assert.that(interval != null, "Null interval in getFreeBlocks");
        if (interval.high < maxSize - 1) {
            ret.add(new Interval(interval.high + 1, maxSize - 1));
        }
        return ret;
    }

    public Iterator getNeededIntervals(int maxSize) {
        return this.invert(maxSize).getAllIntervals();
    }

    public Object clone() {
        IntervalSet ret = new IntervalSet();
        Iterator iter = this.getAllIntervals();
        while (iter.hasNext()) {
            ret.intervals.add(iter.next());
        }
        return ret;
    }

    private void addImpl(Interval i) {
        int point = Collections.binarySearch(this.intervals, i, IntervalComparator.INSTANCE);
        if (point >= 0) {
            throw new IllegalStateException("interval (" + i + ") already in list: " + this.intervals);
        }
        point = -(point + 1);
        this.intervals.add(point, i);
    }

    private void removeImpl(Interval i) {
        int point = Collections.binarySearch(this.intervals, i, IntervalComparator.INSTANCE);
        if (point < 0) {
            throw new IllegalStateException("interval (" + i + ") doesn't exist in list: " + this.intervals);
        }
        this.intervals.remove(point);
    }

    public String toString() {
        return this.intervals.toString();
    }

    public byte[] toBytes() {
        byte[] ret = new byte[this.intervals.size() * 8];
        int pos = 0;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval current = (Interval)iter.next();
            current.toBytes(ret, pos);
            pos += 8;
        }
        return ret;
    }

    public static IntervalSet parseBytes(byte[] data) throws IOException {
        if (data.length % 8 != 0) {
            throw new IOException();
        }
        IntervalSet ret = new IntervalSet();
        for (int i = 0; i < data.length / 8; ++i) {
            int low = (int)ByteOrder.uint2long(ByteOrder.beb2int(data, i * 8));
            int high = (int)ByteOrder.uint2long(ByteOrder.beb2int(data, i * 8 + 4));
            if (high < low || high < 0 || low < 0) {
                throw new IOException();
            }
            ret.add(new Interval(low, high));
        }
        return ret;
    }

    private void fix() {
        String preIntervals = this.intervals.toString();
        ArrayList oldIntervals = new ArrayList(this.intervals);
        this.intervals.clear();
        Iterator i = oldIntervals.iterator();
        while (i.hasNext()) {
            this.add((Interval)i.next());
        }
        String postIntervals = this.intervals.toString();
        Assert.silent(false, "IntervalSet invariants broken.\nPre  Fixing: " + preIntervals + "\n" + "Post Fixing: " + postIntervals);
    }

    private static class IntervalComparator
    implements Comparator {
        private static final IntervalComparator INSTANCE = new IntervalComparator();

        private IntervalComparator() {
        }

        public int compare(Object a, Object b) {
            Interval ia = (Interval)a;
            Interval ib = (Interval)b;
            if (ia.low > ib.low) {
                return 1;
            }
            if (ia.low < ib.low) {
                return -1;
            }
            return 0;
        }
    }
}

