/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.settings.URLHandlerSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.PackagedMediaFileUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.WindowsLauncher;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public final class Launcher {
    private static boolean _macClassesLoadedSuccessfully = true;
    private static Method _openURL;

    private Launcher() {
    }

    public static int openURL(String url) throws IOException {
        if (CommonUtils.isWindows()) {
            return Launcher.openURLWindows(url);
        }
        if (CommonUtils.isMacOSX()) {
            Launcher.openURLMac(url);
        } else {
            Launcher.launchFileOther(url);
        }
        return -1;
    }

    private static int openURLWindows(String url) throws IOException {
        return new WindowsLauncher().openURL(url);
    }

    private static void openURLMac(String url) throws IOException {
        if (!_macClassesLoadedSuccessfully) {
            throw new IOException();
        }
        try {
            Object[] params = new Object[]{url};
            _openURL.invoke(null, params);
        }
        catch (NoSuchMethodError err) {
            throw new IOException();
        }
        catch (NoClassDefFoundError err) {
            throw new IOException();
        }
        catch (IllegalAccessException iae) {
            throw new IOException();
        }
        catch (InvocationTargetException ite) {
            throw new IOException();
        }
    }

    public static int launchFile(File file) throws IOException, SecurityException {
        String path = file.getCanonicalPath();
        String extCheckString = path.toLowerCase();
        if (extCheckString.endsWith(".pmf")) {
            if ((file = PackagedMediaFileUtils.preparePMFFile(file.toString())) == null) {
                return -1;
            }
            path = file.getCanonicalPath();
            extCheckString = path.toLowerCase();
        }
        if (!(extCheckString.endsWith(".exe") || extCheckString.endsWith(".vbs") || extCheckString.endsWith(".lnk") || extCheckString.endsWith(".bat") || extCheckString.endsWith(".sys") || extCheckString.endsWith(".com"))) {
            if (CommonUtils.isWindows()) {
                return Launcher.launchFileWindows(path);
            }
            if (CommonUtils.isMacOSX()) {
                Launcher.launchFileMacOSX(path);
            } else {
                Launcher.launchFileOther(path);
            }
        } else {
            throw new SecurityException();
        }
        return -1;
    }

    public static boolean launchExplorer(File file) throws IOException, SecurityException {
        if (CommonUtils.isWindows()) {
            String explorePath = file.getPath();
            try {
                explorePath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Runtime.getRuntime().exec(new String[]{"explorer", "/select,", explorePath});
            return true;
        }
        if (CommonUtils.isMacOSX()) {
            if (file.isFile()) {
                Launcher.launchFile(file.getParentFile());
            } else {
                Launcher.launchFile(file);
            }
            return true;
        }
        return false;
    }

    private static int launchFileWindows(String path) throws IOException {
        return new WindowsLauncher().launchFile(path);
    }

    private static void launchFileMacOSX(String file) throws IOException {
        Runtime.getRuntime().exec(new String[]{"open", file});
    }

    private static void loadMacClasses() throws IOException {
        try {
            Class<?> mrjAdapter = Class.forName("net.roydesign.mac.MRJAdapter");
            _openURL = mrjAdapter.getDeclaredMethod("openURL", String.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException();
        }
        catch (NoSuchMethodException nsme) {
            throw new IOException();
        }
        catch (SecurityException se) {
            throw new IOException();
        }
    }

    private static void launchFileOther(String path) throws IOException {
        String handler = MediaType.getAudioMediaType().matches(path) ? URLHandlerSettings.AUDIO_PLAYER.getValue() : (MediaType.getVideoMediaType().matches(path) ? URLHandlerSettings.VIDEO_PLAYER.getValue() : (MediaType.getImageMediaType().matches(path) ? URLHandlerSettings.IMAGE_VIEWER.getValue() : URLHandlerSettings.BROWSER.getValue()));
        if (handler.indexOf("$URL$") != -1) {
            System.out.println("starting " + handler);
            StringTokenizer tok = new StringTokenizer(handler);
            String[] strs = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                strs[i] = StringUtils.replace(tok.nextToken(), "$URL$", path);
                System.out.print(" " + strs[i]);
                ++i;
            }
            try {
                Runtime.getRuntime().exec(strs);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("starting " + handler);
            String[] strs = new String[]{handler, path};
            Runtime.getRuntime().exec(strs);
        }
    }

    static {
        if (CommonUtils.isMacOSX()) {
            try {
                Launcher.loadMacClasses();
            }
            catch (IOException ioe) {
                _macClassesLoadedSuccessfully = false;
            }
        }
    }
}

