/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemUtils {
    private static final Log LOG;
    private static boolean isLoaded;

    private SystemUtils() {
    }

    public static long getIdleTime() {
        if (SystemUtils.supportsIdleTime()) {
            return SystemUtils.idleTime();
        }
        return 0L;
    }

    public static boolean supportsIdleTime() {
        if (isLoaded) {
            if (CommonUtils.isWindows2000orXP()) {
                return true;
            }
            if (CommonUtils.isMacOSX()) {
                return true;
            }
        }
        return false;
    }

    public static long setOpenFileLimit(int max) {
        if (isLoaded && CommonUtils.isMacOSX()) {
            return SystemUtils.setOpenFileLimit0(max);
        }
        return -1L;
    }

    static void setWriteable(String fileName) {
        if (isLoaded && (CommonUtils.isWindows() || CommonUtils.isMacOSX())) {
            SystemUtils.setFileWriteable(fileName);
        }
    }

    private static final native long idleTime();

    private static final native int setFileWriteable(String var0);

    private static final native int setOpenFileLimit0(int var0);

    public static final String getRunningPath() {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.getRunningPathNative();
        }
        return "";
    }

    public static final boolean setWindowIcon(Component frame, File icon) {
        if (CommonUtils.isWindows() && isLoaded) {
            try {
                String result = SystemUtils.setWindowIconNative(frame, System.getProperty("sun.boot.library.path"), icon.getPath());
                return result.equals("");
            }
            catch (UnsatisfiedLinkError e) {
                LOG.debug("UnsatisfiedLinkError calling setWindowIconNative()", e);
            }
        }
        return false;
    }

    public static final boolean isFirewallPresent() {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallPresentNative();
        }
        return false;
    }

    public static final boolean isFirewallEnabled() {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallEnabledNative();
        }
        return false;
    }

    public static final boolean isFirewallExceptionsNotAllowed() {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallExceptionsNotAllowedNative();
        }
        return false;
    }

    public static final boolean isProgramListedOnFirewall(String path) {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallIsProgramListedNative(path);
        }
        return false;
    }

    public static final boolean isProgramEnabledOnFirewall(String path) {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallIsProgramEnabledNative(path);
        }
        return false;
    }

    public static final boolean addProgramToFirewall(String path, String name) {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallAddNative(path, name);
        }
        return false;
    }

    public static final boolean removeProgramFromFirewall(String path) {
        if (CommonUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallRemoveNative(path);
        }
        return false;
    }

    private static final native String getRunningPathNative();

    private static final native String setWindowIconNative(Component var0, String var1, String var2);

    private static final native boolean firewallPresentNative();

    private static final native boolean firewallEnabledNative();

    private static final native boolean firewallExceptionsNotAllowedNative();

    private static final native boolean firewallIsProgramListedNative(String var0);

    private static final native boolean firewallIsProgramEnabledNative(String var0);

    private static final native boolean firewallAddNative(String var0, String var1);

    private static final native boolean firewallRemoveNative(String var0);

    static {
        boolean canLoad;
        LOG = LogFactory.getLog(SystemUtils.class);
        try {
            if (CommonUtils.isMacOSX()) {
                System.loadLibrary("SystemUtilities");
            } else if (CommonUtils.isWindows()) {
                System.loadLibrary("GenericWindowsUtils");
                if (CommonUtils.isWindows2000orXP()) {
                    System.loadLibrary("WindowsV5PlusUtils");
                }
                System.loadLibrary("WindowsFirewall");
            }
            canLoad = true;
        }
        catch (UnsatisfiedLinkError noGo) {
            canLoad = false;
        }
        isLoaded = canLoad;
    }
}

