/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.TrieEdge;
import com.limegroup.gnutella.util.TrieNode;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

public class Trie {
    private TrieNode root;
    private boolean ignoreCase;
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();

    public Trie(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.clear();
    }

    public void clear() {
        this.root = new TrieNode();
    }

    public String canonicalCase(String s) {
        if (!this.ignoreCase) {
            return s;
        }
        return s.toUpperCase(Locale.US).toLowerCase(Locale.US);
    }

    private final int match(String a, int startOffset, int stopOffset, String b) {
        int i = startOffset;
        for (int j = 0; j < b.length(); ++j) {
            if (i >= stopOffset) {
                return j;
            }
            if (a.charAt(i) != b.charAt(j)) {
                return j;
            }
            ++i;
        }
        return -1;
    }

    public Object add(String key, Object value) {
        String label;
        key = this.canonicalCase(key);
        TrieNode node = this.root;
        for (int i = 0; i < key.length(); i += label.length()) {
            TrieEdge edge = node.get(key.charAt(i));
            if (edge == null) {
                TrieNode newNode = new TrieNode(value);
                node.put(key.substring(i), newNode);
                return null;
            }
            label = edge.getLabel();
            int j = this.match(key, i, key.length(), label);
            Assert.that(j != 0, "Label didn't start with prefix[0].");
            if (j >= 0) {
                TrieNode child = edge.getChild();
                TrieNode intermediate = new TrieNode();
                String a = label.substring(0, j);
                String b = label.substring(j);
                String c = key.substring(i + j);
                if (c.length() > 0) {
                    TrieNode newNode = new TrieNode(value);
                    node.remove(label.charAt(0));
                    node.put(a, intermediate);
                    intermediate.put(b, child);
                    intermediate.put(c, newNode);
                } else {
                    node.remove(label.charAt(0));
                    node.put(a, intermediate);
                    intermediate.put(b, child);
                    intermediate.setValue(value);
                }
                return null;
            }
            Assert.that(j == -1, "Bad return value from match: " + i);
            node = edge.getChild();
        }
        Object ret = node.getValue();
        node.setValue(value);
        return ret;
    }

    private TrieNode fetch(String prefix) {
        String label;
        TrieNode node = this.root;
        for (int i = 0; i < prefix.length(); i += label.length()) {
            TrieEdge edge = node.get(prefix.charAt(i));
            if (edge == null) {
                return null;
            }
            label = edge.getLabel();
            int j = this.match(prefix, i, prefix.length(), label);
            Assert.that(j != 0, "Label didn't start with prefix[0].");
            if (j != -1) {
                return null;
            }
            node = edge.getChild();
        }
        return node;
    }

    public Object get(String key) {
        TrieNode node = this.fetch(key = this.canonicalCase(key));
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    public boolean remove(String key) {
        TrieNode node = this.fetch(key = this.canonicalCase(key));
        if (node == null) {
            return false;
        }
        boolean ret = node.getValue() != null;
        node.setValue(null);
        return ret;
    }

    public Iterator getPrefixedBy(String prefix) {
        prefix = this.canonicalCase(prefix);
        return this.getPrefixedBy(prefix, 0, prefix.length());
    }

    public Iterator getPrefixedBy(String prefix, int startOffset, int stopOffset) {
        String label;
        TrieNode node = this.root;
        for (int i = startOffset; i < stopOffset; i += label.length()) {
            TrieEdge edge = node.get(prefix.charAt(i));
            if (edge == null) {
                return EMPTY_ITERATOR;
            }
            node = edge.getChild();
            label = edge.getLabel();
            int j = this.match(prefix, i, stopOffset, label);
            Assert.that(j != 0, "Label didn't start with prefix[0].");
            if (i + j == stopOffset) break;
            if (j >= 0) {
                node = null;
                break;
            }
            Assert.that(j == -1, "Bad return value from match: " + i);
        }
        if (node == null) {
            return EMPTY_ITERATOR;
        }
        return new ValueIterator(node);
    }

    public Iterator getIterator() {
        return new ValueIterator(this.root);
    }

    public void trim(Function valueCompactor) throws IllegalArgumentException, ClassCastException {
        if (valueCompactor != null) {
            NodeIterator iter = new NodeIterator(this.root, true);
            while (iter.hasNext()) {
                TrieNode node = (TrieNode)iter.next();
                node.trim();
                Object value = node.getValue();
                if (value == null) continue;
                node.setValue(valueCompactor.apply(value));
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<root>");
        this.toStringHelper(this.root, buf, 1);
        return buf.toString();
    }

    private void toStringHelper(TrieNode start, StringBuffer buf, int indent) {
        if (start.getValue() != null) {
            buf.append(" -> ");
            buf.append(start.getValue().toString());
        }
        buf.append("\n");
        Iterator iter = start.labelsForward();
        while (iter.hasNext()) {
            for (int i = 0; i < indent; ++i) {
                buf.append(" ");
            }
            String label = (String)iter.next();
            buf.append(label);
            TrieNode child = start.get(label.charAt(0)).getChild();
            this.toStringHelper(child, buf, indent + 1);
        }
    }

    public class NodeIterator
    extends UnmodifiableIterator {
        private ArrayList stack = new ArrayList();
        private boolean withNulls;

        public NodeIterator(TrieNode start, boolean withNulls) {
            this.withNulls = withNulls;
            if (withNulls || start.getValue() != null) {
                this.stack.add(start);
            } else {
                this.advance(start);
            }
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        public Object next() {
            int size = this.stack.size();
            if (size == 0) {
                throw new NoSuchElementException();
            }
            TrieNode node = (TrieNode)this.stack.remove(size - 1);
            this.advance(node);
            return node;
        }

        private void advance(TrieNode node) {
            Iterator children = node.childrenForward();
            while (true) {
                if (children.hasNext()) {
                    node = (TrieNode)children.next();
                    if (children.hasNext()) {
                        this.stack.add(children);
                    }
                    if (this.withNulls || node.getValue() == null) {
                        children = node.childrenForward();
                        continue;
                    }
                    this.stack.add(node);
                    return;
                }
                int size = this.stack.size();
                if (size == 0) {
                    return;
                }
                children = (Iterator)this.stack.remove(size - 1);
            }
        }
    }

    private static class EmptyIterator
    extends UnmodifiableIterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    }

    private class ValueIterator
    extends NodeIterator {
        ValueIterator(TrieNode start) {
            super(start, false);
        }

        public Object next() {
            return ((TrieNode)super.next()).getValue();
        }
    }
}

