/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.metadata.MetaDataEditor;
import com.limegroup.gnutella.metadata.MetaDataReader;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.util.Trie;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LimeXMLReplyCollection {
    private static final Log LOG = LogFactory.getLog(LimeXMLReplyCollection.class);
    private final String schemaURI;
    private final Map mainMap;
    private final Map oldMap;
    private final Map trieMap;
    private boolean dirty = false;
    private final File dataFile;
    public static final int NORMAL = 0;
    public static final int FILE_DEFECTIVE = 1;
    public static final int RW_ERROR = 2;
    public static final int BAD_ID3 = 3;
    public static final int FAILED_TITLE = 4;
    public static final int FAILED_ARTIST = 5;
    public static final int FAILED_ALBUM = 6;
    public static final int FAILED_YEAR = 7;
    public static final int FAILED_COMMENT = 8;
    public static final int FAILED_TRACK = 9;
    public static final int FAILED_GENRE = 10;
    public static final int HASH_FAILED = 11;
    public static final int INCORRECT_FILETYPE = 12;

    public LimeXMLReplyCollection(String URI2) {
        this.schemaURI = URI2;
        this.trieMap = new HashMap();
        this.dataFile = new File(LimeXMLProperties.instance().getXMLDocsDir(), LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml");
        this.mainMap = new HashMap();
        this.oldMap = this.readMapFromDisk();
    }

    LimeXMLDocument initialize(FileDesc fd, List potential) {
        URN urn = fd.getSHA1Urn();
        LimeXMLDocument doc = null;
        Iterator i = potential.iterator();
        while (i.hasNext()) {
            LimeXMLDocument next = (LimeXMLDocument)i.next();
            if (!next.getSchemaURI().equals(this.schemaURI)) continue;
            doc = next;
            break;
        }
        if (doc == null) {
            doc = (LimeXMLDocument)this.oldMap.get(urn);
        }
        if (doc != null && (doc = this.validate(doc, fd.getFile(), fd)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding old document for file: " + fd.getFile() + ", doc: " + doc);
            }
            this.addReply(fd, doc);
        }
        return doc;
    }

    LimeXMLDocument createIfNecessary(FileDesc fd) {
        LimeXMLDocument doc = null;
        URN urn = fd.getSHA1Urn();
        if (!this.mainMap.containsKey(urn)) {
            File file = fd.getFile();
            if (!(fd.getLimeXMLDocuments().size() != 0 && LimeXMLUtils.isSupportedMultipleFormat(file) || (doc = this.constructDocument(file)) == null)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding newly constructed document for file: " + file + ", doc: " + doc);
                }
                this.addReply(fd, doc);
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFinished() {
        Map map = this.mainMap;
        synchronized (map) {
            if (((Object)this.oldMap).equals(this.mainMap)) {
                this.dirty = false;
            }
            this.oldMap.clear();
        }
    }

    private LimeXMLDocument validate(LimeXMLDocument doc, File file, FileDesc fd) {
        if (!doc.isCurrent()) {
            LimeXMLDocument tempDoc;
            if (LOG.isDebugEnabled()) {
                LOG.debug("reconstructing old document: " + file);
            }
            if ((tempDoc = this.constructDocument(file)) != null) {
                doc = this.update(doc, tempDoc);
            } else {
                doc.setCurrent();
            }
        }
        if (!doc.isValid() && (doc = this.constructDocument(file)) == null) {
            return null;
        }
        if (AudioMetaData.isCorrupted(doc)) {
            doc = AudioMetaData.fixCorruption(doc);
            this.mediaFileToDisk(fd, file.getPath(), doc, false);
        }
        return doc;
    }

    private LimeXMLDocument update(LimeXMLDocument older, LimeXMLDocument newer) {
        Map.Entry next;
        HashMap fields = new HashMap();
        Iterator i = newer.getNameValueSet().iterator();
        while (i.hasNext()) {
            next = (Map.Entry)i.next();
            fields.put(next.getKey(), next.getValue());
        }
        i = older.getNameValueSet().iterator();
        while (i.hasNext()) {
            next = (Map.Entry)i.next();
            if (fields.containsKey(next.getKey())) continue;
            fields.put(next.getKey(), next.getValue());
        }
        ArrayList<NameValue> nameValues = new ArrayList<NameValue>(fields.size());
        Iterator i2 = fields.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry next2 = i2.next();
            nameValues.add(new NameValue((String)next2.getKey(), next2.getValue()));
        }
        return new LimeXMLDocument(nameValues, newer.getSchemaURI());
    }

    private LimeXMLDocument constructDocument(File file) {
        if (LimeXMLUtils.isSupportedFormatForSchema(file, this.schemaURI)) {
            try {
                LimeXMLDocument document = MetaDataReader.readDocument(file);
                if (document.getSchemaURI().equals(this.schemaURI)) {
                    return document;
                }
            }
            catch (IOException ignored) {
                LOG.warn("Error creating document", ignored);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getKeyWords() {
        ArrayList retList = new ArrayList();
        Map map = this.mainMap;
        synchronized (map) {
            Iterator docs = this.mainMap.values().iterator();
            while (docs.hasNext()) {
                LimeXMLDocument d = (LimeXMLDocument)docs.next();
                retList.addAll(d.getKeyWords());
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getKeyWordsIndivisible() {
        ArrayList retList = new ArrayList();
        Map map = this.mainMap;
        synchronized (map) {
            Iterator docs = this.mainMap.values().iterator();
            while (docs.hasNext()) {
                LimeXMLDocument d = (LimeXMLDocument)docs.next();
                retList.addAll(d.getKeyWordsIndivisible());
            }
        }
        return retList;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeywords(LimeXMLDocument doc) {
        Map map = this.mainMap;
        synchronized (map) {
            Iterator i = doc.getNameValueSet().iterator();
            while (i.hasNext()) {
                LinkedList<LimeXMLDocument> allDocs;
                Map.Entry entry = (Map.Entry)i.next();
                String name = (String)entry.getKey();
                String value = I18NConvert.instance().getNorm((String)entry.getValue());
                Trie trie = (Trie)this.trieMap.get(name);
                if (trie == null) {
                    trie = new Trie(true);
                    this.trieMap.put(name, trie);
                }
                if ((allDocs = (LinkedList<LimeXMLDocument>)trie.get(value)) == null) {
                    allDocs = new LinkedList<LimeXMLDocument>();
                    trie.add(value, allDocs);
                }
                allDocs.add(doc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeywords(LimeXMLDocument doc) {
        Map map = this.mainMap;
        synchronized (map) {
            Iterator i = doc.getNameValueSet().iterator();
            while (i.hasNext()) {
                String value;
                List allDocs;
                Map.Entry entry = (Map.Entry)i.next();
                String name = (String)entry.getKey();
                Trie trie = (Trie)this.trieMap.get(name);
                if (trie == null || (allDocs = (List)trie.get(value = I18NConvert.instance().getNorm((String)entry.getValue()))) == null) continue;
                allDocs.remove(doc);
                if (allDocs.size() != 0) continue;
                trie.remove(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReply(FileDesc fd, LimeXMLDocument replyDoc) {
        URN hash = fd.getSHA1Urn();
        Map map = this.mainMap;
        synchronized (map) {
            this.dirty = true;
            this.mainMap.put(hash, replyDoc);
            this.addKeywords(replyDoc);
        }
        fd.addLimeXMLDocument(replyDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Map map = this.mainMap;
        synchronized (map) {
            return this.mainMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument getDocForHash(URN hash) {
        Map map = this.mainMap;
        synchronized (map) {
            return (LimeXMLDocument)this.mainMap.get(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getMatchingReplies(LimeXMLDocument query) {
        Iterator i;
        HashSet matching = null;
        Map map = this.mainMap;
        synchronized (map) {
            i = query.getNameValueSet().iterator();
            while (i.hasNext()) {
                String value;
                Iterator iter;
                Map.Entry entry = (Map.Entry)i.next();
                String name = (String)entry.getKey();
                Trie trie = (Trie)this.trieMap.get(name);
                if (trie == null || !(iter = trie.getPrefixedBy(value = (String)entry.getValue())).hasNext()) continue;
                if (matching == null) {
                    matching = new HashSet();
                }
                while (iter.hasNext()) {
                    List matchesVal = (List)iter.next();
                    matching.addAll(matchesVal);
                }
            }
        }
        if (matching == null || matching.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<LimeXMLDocument> actualMatches = null;
        i = matching.iterator();
        while (i.hasNext()) {
            LimeXMLDocument currReplyDoc = (LimeXMLDocument)i.next();
            if (!LimeXMLUtils.match(currReplyDoc, query, false)) continue;
            if (actualMatches == null) {
                actualMatches = new LinkedList<LimeXMLDocument>();
            }
            actualMatches.add(currReplyDoc);
        }
        if (actualMatches == null || actualMatches.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return actualMatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument replaceDoc(FileDesc fd, LimeXMLDocument newDoc) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Replacing doc in FD (" + fd + ") with new doc (" + newDoc + ")");
        }
        LimeXMLDocument oldDoc = null;
        URN hash = fd.getSHA1Urn();
        Map map = this.mainMap;
        synchronized (map) {
            this.dirty = true;
            oldDoc = this.mainMap.put(hash, newDoc);
            if (oldDoc == null) {
                Assert.that(false, "attempted to replace doc that did not exist!!");
            }
            this.removeKeywords(oldDoc);
            this.addKeywords(newDoc);
        }
        fd.replaceLimeXMLDocument(oldDoc, newDoc);
        return oldDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDoc(FileDesc fd) {
        LimeXMLDocument val;
        Map map = this.mainMap;
        synchronized (map) {
            val = (LimeXMLDocument)this.mainMap.remove(fd.getSHA1Urn());
            if (val != null) {
                this.dirty = true;
            }
        }
        if (val != null) {
            fd.removeLimeXMLDocument(val);
            this.removeKeywords(val);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed: " + val);
        }
        return val != null;
    }

    public int mediaFileToDisk(FileDesc fd, String fileName, LimeXMLDocument doc, boolean checkBetter) {
        MetaDataEditor commitWith;
        int writeState = -1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing: " + fileName + " to disk.");
        }
        if ((commitWith = this.getEditorIfNeeded(fileName, doc, checkBetter)) != null) {
            if (commitWith.getCorrectDocument() == null) {
                writeState = this.commitMetaData(fileName, commitWith);
            } else {
                this.removeDoc(fd);
                this.addReply(fd, commitWith.getCorrectDocument());
                writeState = 0;
            }
        }
        Assert.that(writeState != 12, "trying to write data to unwritable file");
        return writeState;
    }

    private MetaDataEditor getEditorIfNeeded(String mp3File, LimeXMLDocument doc, boolean checkBetter) {
        MetaDataEditor newValues = MetaDataEditor.getEditorForFile(mp3File);
        if (newValues == null) {
            return null;
        }
        newValues.populate(doc);
        MetaDataEditor existing = MetaDataEditor.getEditorForFile(mp3File);
        LimeXMLDocument existingDoc = null;
        try {
            existingDoc = MetaDataReader.readDocument(new File(mp3File));
        }
        catch (IOException e) {
            return null;
        }
        existing.populate(existingDoc);
        if (newValues.equals(existing)) {
            LOG.debug("tag read from disk is same as XML doc.");
            return null;
        }
        if (checkBetter) {
            if (existing.betterThan(newValues)) {
                LOG.debug("Data on disk is better, using disk data.");
                existing.setCorrectDocument(existingDoc);
                return existing;
            }
            LOG.debug("Retrieving better fields from disk.");
            newValues.pickBetterFields(existing);
        }
        return newValues;
    }

    private int commitMetaData(String fileName, MetaDataEditor editor) {
        int retVal = editor.commitMetaData(fileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("wrote data: " + retVal);
        }
        if (retVal == 1 || retVal == 2 || retVal == 3 || retVal == 12) {
            return retVal;
        }
        RouterService.getFileManager().fileChanged(new File(fileName));
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMapToDisk() {
        boolean wrote = false;
        Map map = this.mainMap;
        synchronized (map) {
            if (!this.dirty) {
                return true;
            }
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.dataFile)));
                out.writeObject(this.mainMap);
                out.flush();
                wrote = true;
            }
            catch (Throwable ignored) {
                try {
                    LOG.trace("Unable to write", ignored);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtils.close(out);
                }
            }
            IOUtils.close(out);
            this.dirty = false;
        }
        return wrote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map readMapFromDisk() {
        ConverterObjectInputStream in = null;
        Map read = null;
        try {
            in = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(this.dataFile)));
            read = (Map)in.readObject();
        }
        catch (Throwable t) {
            try {
                LOG.error("Unable to read LimeXMLCollection", t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.close(in);
            }
        }
        IOUtils.close(in);
        return read == null ? new HashMap() : read;
    }
}

