/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LimeXMLSchemaRepository {
    private Map _uriSchemaMap = new HashMap();
    private static LimeXMLSchemaRepository _instance = new LimeXMLSchemaRepository();

    private LimeXMLSchemaRepository() {
        this.initialize();
    }

    protected void initialize() {
        File[] schemaFiles = LimeXMLProperties.instance().getAllXMLSchemaFiles();
        if (schemaFiles != null) {
            for (int i = 0; i < schemaFiles.length; ++i) {
                try {
                    LimeXMLSchema limeXmlSchema = new LimeXMLSchema(schemaFiles[i]);
                    this._uriSchemaMap.put(limeXmlSchema.getSchemaURI(), limeXmlSchema);
                    continue;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    public static LimeXMLSchemaRepository instance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLSchema getSchema(String uri) {
        Map map = this._uriSchemaMap;
        synchronized (map) {
            return (LimeXMLSchema)this._uriSchemaMap.get(uri);
        }
    }

    public Collection getAvailableSchemas() {
        return Collections.unmodifiableCollection(this._uriSchemaMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAvailableSchemaURIs() {
        Object[] schemaURIs;
        Map map = this._uriSchemaMap;
        synchronized (map) {
            Set keySet = this._uriSchemaMap.keySet();
            schemaURIs = keySet.toArray(new String[0]);
        }
        Arrays.sort(schemaURIs);
        return schemaURIs;
    }
}

