/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.metadata.MetaDataReader;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetaFileManager
extends FileManager {
    private static final Log LOG = LogFactory.getLog(MetaFileManager.class);
    private Saver saver;

    public synchronized Response[] query(QueryRequest request) {
        Response[] metas;
        LimeXMLDocument doc;
        Response[] result = super.query(request);
        if (this.shouldIncludeXMLInResponse(request) && (doc = request.getRichQuery()) != null && (metas = this.query(doc)) != null) {
            result = this.union(result, metas, doc);
        }
        return result;
    }

    protected boolean isValidXMLMatch(Response r, LimeXMLDocument doc) {
        return LimeXMLUtils.match(r.getDocument(), doc, true);
    }

    protected boolean shouldIncludeXMLInResponse(QueryRequest qr) {
        return qr.desiresXMLResponses() || qr.desiresOutOfBandReplies();
    }

    protected void addXMLToResponse(Response response, FileDesc fd) {
        List docs = fd.getLimeXMLDocuments();
        if (docs.size() == 0) {
            return;
        }
        if (docs.size() == 1) {
            response.setDocument((LimeXMLDocument)docs.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileChanged(File f) {
        FileDesc removed;
        FileDesc fd;
        if (LOG.isTraceEnabled()) {
            LOG.debug("File Changed: " + f);
        }
        if ((fd = this.getFileDescForFile(f)) == null) {
            return;
        }
        CreationTimeCache ctCache = CreationTimeCache.instance();
        final Long cTime = ctCache.getCreationTime(fd.getSHA1Urn());
        List xmlDocs = fd.getLimeXMLDocuments();
        if (LimeXMLUtils.isEditableFormat(f)) {
            try {
                LimeXMLDocument diskDoc = MetaDataReader.readDocument(f);
                xmlDocs = this.resolveWriteableDocs(xmlDocs, diskDoc);
            }
            catch (IOException e) {
                xmlDocs = Collections.EMPTY_LIST;
            }
        }
        if (fd != (removed = this.removeFileIfShared(f, false))) {
            Assert.that(false, "wanted to remove: " + fd + "\ndid remove: " + removed);
        }
        MetaFileManager metaFileManager = this;
        synchronized (metaFileManager) {
            _needRebuild = true;
        }
        this.addFileIfShared(f, xmlDocs, false, this._revision, new FileEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleFileEvent(FileManagerEvent evt) {
                FileManagerEvent newEvt = null;
                if (evt.isAddEvent()) {
                    CreationTimeCache ctCache;
                    FileDesc fd = evt.getFileDescs()[0];
                    CreationTimeCache creationTimeCache = ctCache = CreationTimeCache.instance();
                    synchronized (creationTimeCache) {
                        ctCache.removeTime(fd.getSHA1Urn());
                        ctCache.addTime(fd.getSHA1Urn(), cTime);
                        ctCache.commitTime(fd.getSHA1Urn());
                    }
                    newEvt = new FileManagerEvent((FileManager)MetaFileManager.this, 4, new FileDesc[]{removed, fd});
                } else {
                    newEvt = new FileManagerEvent((FileManager)MetaFileManager.this, 2, removed);
                }
                MetaFileManager.this.dispatchFileEvent(newEvt);
            }
        });
    }

    private List resolveWriteableDocs(List allDocs, LimeXMLDocument id3Doc) {
        LimeXMLDocument audioDoc = null;
        LimeXMLSchema audioSchema = LimeXMLSchemaRepository.instance().getSchema(AudioMetaData.schemaURI);
        Iterator iter = allDocs.iterator();
        while (iter.hasNext()) {
            LimeXMLDocument doc = (LimeXMLDocument)iter.next();
            if (doc.getSchema() != audioSchema) continue;
            audioDoc = doc;
            break;
        }
        if (id3Doc.equals(audioDoc)) {
            return allDocs;
        }
        ArrayList<LimeXMLDocument> retList = new ArrayList<LimeXMLDocument>();
        retList.addAll(allDocs);
        if (audioDoc == null) {
            retList.add(id3Doc);
            return retList;
        }
        retList.remove(audioDoc);
        List audioList = audioDoc.getOrderedNameValueList();
        List id3List = id3Doc.getOrderedNameValueList();
        for (int i = 0; i < audioList.size(); ++i) {
            NameValue nameVal = (NameValue)audioList.get(i);
            if (!AudioMetaData.isNonLimeAudioField(nameVal.getName())) continue;
            id3List.add(nameVal);
        }
        audioDoc = new LimeXMLDocument(id3List, AudioMetaData.schemaURI);
        retList.add(audioDoc);
        return retList;
    }

    protected synchronized FileDesc removeFileIfShared(File f, boolean notify) {
        FileDesc fd = super.removeFileIfShared(f, notify);
        if (fd == null) {
            return null;
        }
        SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
        List xmlDocs = fd.getLimeXMLDocuments();
        LinkedList<String> schemas = new LinkedList<String>();
        Iterator i = xmlDocs.iterator();
        while (i.hasNext()) {
            schemas.add(((LimeXMLDocument)i.next()).getSchemaURI());
        }
        i = schemas.iterator();
        while (i.hasNext()) {
            String uri = (String)i.next();
            LimeXMLReplyCollection col = mapper.getReplyCollection(uri);
            if (col == null) continue;
            col.removeDoc(fd);
        }
        _needRebuild = true;
        return fd;
    }

    protected void loadStarted(int revision) {
        RouterService.getCallback().setAnnotateEnabled(false);
        LimeXMLSchemaRepository schemaRepository = LimeXMLSchemaRepository.instance();
        String[] schemas = schemaRepository.getAvailableSchemaURIs();
        SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
        for (int i = 0; i < schemas.length; ++i) {
            mapper.add(schemas[i], new LimeXMLReplyCollection(schemas[i]));
        }
        super.loadStarted(revision);
    }

    protected void loadFinished(int revision) {
        if (this.saver == null) {
            this.saver = new Saver();
            RouterService.schedule(this.saver, 60000L, 60000L);
        }
        Collection replies = SchemaReplyCollectionMapper.instance().getCollections();
        Iterator i = replies.iterator();
        while (i.hasNext()) {
            ((LimeXMLReplyCollection)i.next()).loadFinished();
        }
        RouterService.getCallback().setAnnotateEnabled(true);
        super.loadFinished(revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFile(FileDesc fd, File file, List metadata, Set urns) {
        super.loadFile(fd, file, metadata, urns);
        boolean added = false;
        Collection replies = SchemaReplyCollectionMapper.instance().getCollections();
        Iterator i = replies.iterator();
        while (i.hasNext()) {
            added |= ((LimeXMLReplyCollection)i.next()).initialize(fd, metadata) != null;
        }
        i = replies.iterator();
        while (i.hasNext()) {
            added |= ((LimeXMLReplyCollection)i.next()).createIfNecessary(fd) != null;
        }
        if (added) {
            MetaFileManager metaFileManager = this;
            synchronized (metaFileManager) {
                _needRebuild = true;
            }
        }
    }

    protected void save() {
        if (this.isLoadFinished()) {
            Collection replies = SchemaReplyCollectionMapper.instance().getCollections();
            Iterator i = replies.iterator();
            while (i.hasNext()) {
                ((LimeXMLReplyCollection)i.next()).writeMapToDisk();
            }
        }
        super.save();
    }

    private Response[] union(Response[] normals, Response[] metas, LimeXMLDocument requested) {
        int i;
        if (normals == null || normals.length == 0) {
            return metas;
        }
        if (metas == null || metas.length == 0) {
            return normals;
        }
        HashSet<Response> unionSet = new HashSet<Response>();
        for (i = 0; i < metas.length; ++i) {
            unionSet.add(metas[i]);
        }
        for (i = 0; i < normals.length; ++i) {
            unionSet.add(normals[i]);
        }
        Response[] retArray = new Response[unionSet.size()];
        retArray = unionSet.toArray(retArray);
        return retArray;
    }

    protected void buildQRT() {
        super.buildQRT();
        Iterator iter = this.getXMLKeyWords().iterator();
        while (iter.hasNext()) {
            _queryRouteTable.add((String)iter.next());
        }
        iter = this.getXMLIndivisibleKeyWords().iterator();
        while (iter.hasNext()) {
            _queryRouteTable.addIndivisible((String)iter.next());
        }
    }

    private List getXMLKeyWords() {
        ArrayList words = new ArrayList();
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        String[] schemas = rep.getAvailableSchemaURIs();
        int len = schemas.length;
        for (int i = 0; i < len; ++i) {
            LimeXMLReplyCollection collection = map.getReplyCollection(schemas[i]);
            if (collection == null) continue;
            words.addAll(collection.getKeyWords());
        }
        return words;
    }

    private List getXMLIndivisibleKeyWords() {
        ArrayList<String> words = new ArrayList<String>();
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        String[] schemas = rep.getAvailableSchemaURIs();
        for (int i = 0; i < schemas.length; ++i) {
            LimeXMLReplyCollection collection;
            if (schemas[i] != null) {
                words.add(schemas[i]);
            }
            if ((collection = map.getReplyCollection(schemas[i])) == null) continue;
            words.addAll(collection.getKeyWordsIndivisible());
        }
        return words;
    }

    private Response[] query(LimeXMLDocument queryDoc) {
        String schema = queryDoc.getSchemaURI();
        SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection replyCol = mapper.getReplyCollection(schema);
        if (replyCol == null) {
            return null;
        }
        List matchingReplies = replyCol.getMatchingReplies(queryDoc);
        int s = matchingReplies.size();
        if (s == 0) {
            return null;
        }
        Response[] retResponses = new Response[s];
        int z = 0;
        Iterator i = matchingReplies.iterator();
        while (i.hasNext()) {
            LimeXMLDocument currDoc = (LimeXMLDocument)i.next();
            File file = currDoc.getIdentifier();
            Response res = null;
            if (file == null) {
                res = new Response(0xFFFFFFFFL, 0L, " ");
            } else {
                FileDesc fd = RouterService.getFileManager().getFileDescForFile(file);
                if (fd == null) continue;
                res = new Response(fd);
                fd.incrementHitCount();
                RouterService.getCallback().handleSharedFileUpdate(fd.getFile());
            }
            res.setDocument(currDoc);
            retResponses[z] = res;
            ++z;
        }
        if (z == 0) {
            return null;
        }
        if (z < s) {
            Response[] temp = new Response[z];
            System.arraycopy(retResponses, 0, temp, 0, z);
            retResponses = temp;
        }
        return retResponses;
    }

    private class Saver
    implements Runnable {
        private Saver() {
        }

        public void run() {
            if (!MetaFileManager.this.shutdown && MetaFileManager.this.isLoadFinished()) {
                MetaFileManager.this.save();
            }
        }
    }
}

