/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.bio;

import de.kapsi.net.daap.DaapAudioResponse;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapStreamException;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.bio.DaapConnectionBIO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;

public class DaapAudioResponseBIO
extends DaapAudioResponse {
    private boolean headerWritten = false;
    private boolean audioWritten = false;
    private OutputStream out;

    public DaapAudioResponseBIO(DaapRequest request, Song song, File file, long pos, long end) throws IOException {
        this(request, song, new FileInputStream(file), pos, end);
    }

    public DaapAudioResponseBIO(DaapRequest request, Song song, FileInputStream in, long pos, long end) throws IOException {
        super(request, song, in, pos, end);
        DaapConnectionBIO connection = (DaapConnectionBIO)request.getConnection();
        this.out = connection.getOutputStream();
    }

    public boolean hasRemaining() {
        return !this.headerWritten || !this.audioWritten;
    }

    public boolean write() throws IOException {
        try {
            if (!this.headerWritten) {
                this.out.write(this.header, 0, this.header.length);
                this.out.flush();
                this.headerWritten = true;
            }
            boolean err = this.stream();
            return err;
        }
        catch (SocketException err) {
            throw new DaapStreamException(err);
        }
        finally {
            this.close();
        }
    }

    private boolean stream() throws IOException {
        byte[] buffer = new byte[512];
        int total = 0;
        int len = -1;
        if (this.pos != 0L) {
            this.in.skip(this.pos);
        }
        while ((len = this.in.read(buffer, 0, buffer.length)) != -1 && (long)total < this.end) {
            this.out.write(buffer, 0, len);
            total += len;
        }
        this.out.flush();
        return true;
    }

    protected void close() throws IOException {
        super.close();
    }
}

