@echo off
rem Copyright 2008-2009 Siep Kroonenberg, Tomasz M. Trzeciak.
rem You may freely use, modify and/or distribute this file.

rem First, check if this is DOS based system
rem in DOS '^' is just a normal character
if not ^x==x goto DOS

rem Abort if we are running from UNC path
if %~d0==\\ goto UNC

rem Localize environment changes
setlocal enableextensions

rem TeX Live Root; ends with backslash
set TEXDIR=%~dp0

rem TEXDIR writable?
set TEXDIRW=%USERPROFILE%\.tlportable2009\
del "%TEXDIR%tl_wrtest" 2>nul
echo Testing for write access %TEXDIR%...
echo Hello >"%TEXDIR%tl_wrtest"
if not exist "%TEXDIR%tl_wrtest" goto wrtestdone
del "%TEXDIR%tl_wrtest"
set TEXDIRW=%TEXDIR%
:wrtestdone
if not exist "%TEXDIRW%" md "%TEXDIRW%"

rem Use TEXMFHOME for private data,
rem TEXMFLOCAL for department- or workgroup data.
rem It is allright if TEXMFLOCAL does not exist.

set TEXMFSYSVAR=%TEXDIRW%texmf-var
if exist "%TEXDIR%texmf-var" set TEXMFSYSVAR=%TEXDIR%texmf-var

set TEXMFSYSCONFIG=%TEXDIRW%texmf-config
if exist "%TEXDIR%texmf-config" set TEXMFSYSCONFIG=%TEXDIR%texmf-config
set TEXMFMAIN=%TEXDIR%texmf
set TEXMFDIST=%TEXDIR%texmf-dist
set TEXMFLOCAL=%TEXDIR%texmf-local
set TEXMFHOME=%TEXDIRW%texmf-home
set TEXMFVAR=%TEXDIRW%texmf-var
set TEXMFCONFIG=%TEXDIRW%texmf-config
set TEXBINDIR=%TEXDIR%bin\win32
set platform=win32

rem use provided Perl
set PERL5LIB=%TEXDIR%tlpkg\tlperl\lib
path %TEXDIR%tlpkg\tlperl\bin;%TEXDIR%bin\win32;%path%
perl "%TEXDIR%install-tl" --portable
if errorlevel 1 goto failedinit

rem start new command interperter with customized prompt and window title
"%ComSpec%" /k "title TL-SHELL& prompt TL %prompt%"
goto :eof

:failedinit
echo Initialization of TeX Live failed!
pause
exit /b 1

:UNC
echo Cannot run from UNC path.
echo Map network drive to a drive letter and rerun the script.
echo You can use pushd/popd commands for temporary mapping.
pause
exit /b 1

:DOS
echo DOS and Windows 9x systems are not supported. Sorry.
echo Windows 2000 or newer is required.
pause
